/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.cubesideutils.bukkit.commands.CommandRouter;
import de.iani.cubesideutils.bukkit.items.ItemStacks;
import de.iani.cubesideutils.commands.PermissionRequirer;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.PlayerUUIDCache;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChestAPI;
import de.iani.treasurechest.TreasureChestData;
import de.iani.treasurechest.TreasureChestItem;
import de.iani.treasurechest.commands.AddItemCommand;
import de.iani.treasurechest.commands.AddMoneyCommand;
import de.iani.treasurechest.commands.CreateCommand;
import de.iani.treasurechest.commands.GiveCommand;
import de.iani.treasurechest.commands.HelpCommand;
import de.iani.treasurechest.commands.ListCommand;
import de.iani.treasurechest.commands.RemoveCommand;
import de.iani.treasurechest.commands.SetChestCommand;
import de.iani.treasurechest.commands.UpdateAllCommand;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import de.iani.treasurechest.database.SQLConfig;
import de.iani.treasurechest.database.TreasureChestDatabase;
import de.iani.treasurechest.listener.ChestInventoryListener;
import de.iani.treasurechest.listener.PlayerEventListener;
import de.iani.treasurechest.worker.WorkerThread;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreasureChest
extends JavaPlugin
implements TreasureChestAPI {
    private TreasureChestData data;
    private Location chestLocation;
    private Random random;
    private boolean hasEconomy;
    private Economy economy;
    private PlayerUUIDCache playerUUIDCache;
    private SQLConfig sqlConfig;
    private TreasureChestDatabase database;
    private WorkerThread workerThread;

    public void onEnable() {
        this.saveDefaultConfig();
        this.random = new Random();
        this.setupEconomy();
        this.playerUUIDCache = (PlayerUUIDCache)this.getServer().getPluginManager().getPlugin("PlayerUUIDCache");
        this.readConfig();
        try {
            this.database = new TreasureChestDatabase(this, this.sqlConfig);
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not connect to database: " + e.getMessage(), e);
            this.setEnabled(false);
            return;
        }
        this.workerThread = new WorkerThread(this);
        this.data = new TreasureChestData(this);
        CommandRouter treasurechestCommand = new CommandRouter(this.getCommand("treasurechest"));
        treasurechestCommand.addCommandMapping((PermissionRequirer)new HelpCommand(this), new String[0]);
        treasurechestCommand.addCommandMapping((PermissionRequirer)new HelpCommand(this), new String[]{"help"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new SetChestCommand(this), new String[]{"setchest"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new CreateCommand(this), new String[]{"create"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new AddItemCommand(this), new String[]{"additem"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new AddMoneyCommand(this), new String[]{"addmoney"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new GiveCommand(this), new String[]{"give"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new ListCommand(this), new String[]{"list"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new RemoveCommand(this), new String[]{"remove"});
        treasurechestCommand.addCommandMapping((PermissionRequirer)new UpdateAllCommand(this), new String[]{"updateall"});
        this.getServer().getPluginManager().registerEvents((Listener)new ChestInventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::createParticles, 1L, 1L);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this.data::doGC, 8456L, 140000L);
    }

    public void onDisable() {
        if (this.workerThread != null) {
            this.workerThread.shutdown();
            this.workerThread = null;
        }
        if (this.database != null) {
            this.database.disconnect();
            this.database = null;
        }
    }

    public PlayerUUIDCache getPlayerUUIDCache() {
        return this.playerUUIDCache;
    }

    @Override
    public boolean addItem(String player, ItemStack displayItem, ItemStack[] items, int money) {
        if (!this.getServer().isPrimaryThread()) {
            return false;
        }
        CachedPlayer id = this.playerUUIDCache.getPlayerFromNameOrUUID(player, true);
        if (id == null) {
            return false;
        }
        return this.addItem(id.getUUID(), displayItem, items, money);
    }

    @Override
    public boolean addItem(OfflinePlayer player, ItemStack displayItem, ItemStack[] items, int money) {
        if (!this.getServer().isPrimaryThread()) {
            return false;
        }
        return this.addItem(player.getUniqueId(), displayItem, items, money);
    }

    private boolean addItem(final UUID player, ItemStack displayItem, ItemStack[] items, int money) {
        if (displayItem == null || displayItem.getAmount() == 0 || displayItem.getType() == Material.AIR) {
            return false;
        }
        ArrayList<ItemStack> copied = new ArrayList<ItemStack>();
        if (items != null) {
            for (ItemStack is : items) {
                if ((is = ItemStacks.prepareForSerialization((ItemStack)is)) == null || is.getAmount() <= 0 || is.getType() == Material.AIR) continue;
                copied.add(is.clone());
            }
            items = copied.toArray(new ItemStack[copied.size()]);
        }
        TreasureChestItem item = new TreasureChestItem(ItemStacks.prepareForSerialization((ItemStack)displayItem), items, money);
        this.workerThread.addWork(database -> {
            try {
                final DatabaseTreasureChestItem added = database.addItem(player, item);
                if (added != null) {
                    new BukkitRunnable(){

                        public void run() {
                            PlayerTreasureChestContent cc = TreasureChest.this.getData().getChestContent(player);
                            if (cc != null && cc.getLoadState() == PlayerTreasureChestContent.LoadState.LOADED) {
                                cc.addItem(added);
                            }
                        }
                    }.runTask((Plugin)this);
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Could not add treasure chest item to database: " + e.getMessage(), e);
            }
        });
        return true;
    }

    private void readConfig() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection section = config.getConfigurationSection("chestLocation");
        if (section != null) {
            World world;
            String worldName = section.getString("world");
            int x = section.getInt("x");
            int y = section.getInt("y");
            int z = section.getInt("z");
            if (worldName != null && (world = this.getServer().getWorld(worldName)) != null) {
                this.chestLocation = new Location(world, (double)x, (double)y, (double)z);
            }
        }
        this.sqlConfig = new SQLConfig(config.getConfigurationSection("database"));
    }

    public void saveConfig() {
        FileConfiguration config = this.getConfig();
        if (this.chestLocation == null || this.chestLocation.getWorld() == null) {
            config.set("chestLocation", null);
        } else {
            ConfigurationSection section = config.getConfigurationSection("chestLocation");
            if (section == null) {
                section = config.createSection("chestLocation");
            }
            section.set("world", (Object)this.chestLocation.getWorld().getName());
            section.set("x", (Object)this.chestLocation.getBlockX());
            section.set("y", (Object)this.chestLocation.getBlockY());
            section.set("z", (Object)this.chestLocation.getBlockZ());
        }
        super.saveConfig();
    }

    public TreasureChestData getData() {
        return this.data;
    }

    public Location getChestLocation() {
        return this.chestLocation;
    }

    protected void createParticles() {
        if (this.random.nextInt(10) == 0 && this.chestLocation != null && this.chestLocation.getWorld() != null) {
            Location playerLocation = new Location(null, 0.0, 0.0, 0.0);
            for (Player player : this.getServer().getOnlinePlayers()) {
                PlayerTreasureChestContent playerData;
                double dz;
                double dy;
                if (player.getWorld() != this.chestLocation.getWorld()) continue;
                player.getLocation(playerLocation);
                double dx = playerLocation.getX() - this.chestLocation.getX();
                double dsquared = dx * dx + (dy = playerLocation.getY() - this.chestLocation.getY()) * dy + (dz = playerLocation.getZ() - this.chestLocation.getZ()) * dz;
                if (!(dsquared < 576.0) || (playerData = this.data.getChestContent(player.getUniqueId())) == null) continue;
                playerData.loadAsync();
                if (playerData.isEmpty()) continue;
                player.playEffect(this.chestLocation, Effect.MOBSPAWNER_FLAMES, null);
            }
        }
    }

    public void sendMessage(CommandSender p, String text) {
        this.sendMessage(p, text, false);
    }

    public void sendMessage(CommandSender p, String text, boolean error) {
        p.sendMessage(String.valueOf(ChatColor.BLUE) + "[TC] " + String.valueOf(error ? ChatColor.DARK_RED : ChatColor.YELLOW) + text);
    }

    public void setChestLocation(Location location) {
        this.chestLocation = location;
        this.saveConfig();
    }

    public SQLConfig getSqlConfig() {
        return this.sqlConfig;
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null && economyProvider.getProvider() != null) {
                this.economy = (Economy)economyProvider.getProvider();
                this.hasEconomy = true;
            } else {
                this.getLogger().warning("Kein Economy-Plugin! Es k\u00f6nnen keine Preisgelder ausgezahlt werden!");
            }
        }
        catch (Throwable e) {
            this.getLogger().warning("Vault nicht gefunden! Es k\u00f6nnen keine Preisgelder ausgezahlt werden!");
        }
    }

    public boolean hasEconomy() {
        return this.hasEconomy;
    }

    public void giveMoney(Player player, int amount) {
        if (this.hasEconomy) {
            try {
                this.economy.depositPlayer((OfflinePlayer)player, (double)amount);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "Error paying money", e);
            }
        }
    }

    public String formatMoney(int amount) {
        if (this.hasEconomy) {
            try {
                return this.economy.format((double)amount);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "Error formating money", e);
            }
        }
        return Integer.toString(amount);
    }

    public TreasureChestDatabase getDatabase() {
        return this.database;
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }
}

