/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.worker;

import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.database.TreasureChestDatabase;
import de.iani.treasurechest.worker.WorkEntry;
import java.util.ArrayDeque;
import java.util.logging.Level;

public class WorkerThread
extends Thread {
    private TreasureChest plugin;
    private TreasureChestDatabase database;
    private boolean stopping;
    private ArrayDeque<WorkEntry> work;

    public WorkerThread(TreasureChest plugin) {
        this.plugin = plugin;
        this.work = new ArrayDeque();
        this.database = plugin.getDatabase();
        this.setName("TreasureChest worker");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWork(WorkEntry e) {
        ArrayDeque<WorkEntry> arrayDeque = this.work;
        synchronized (arrayDeque) {
            this.work.addLast(e);
            this.work.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayDeque<WorkEntry> arrayDeque = this.work;
        synchronized (arrayDeque) {
            this.stopping = true;
            this.work.notify();
        }
        boolean interrupt = false;
        while (this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                interrupt = true;
            }
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            WorkEntry e;
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                e = this.work.pollFirst();
                if (e == null) {
                    if (this.stopping) {
                        return;
                    }
                    try {
                        this.work.wait();
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (e == null || this.database == null) continue;
            try {
                e.process(this.database);
                continue;
            }
            catch (Exception er) {
                this.plugin.getLogger().log(Level.SEVERE, "Error in TreasureChest worker thread", er);
                continue;
            }
            break;
        }
    }
}

