/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.ListedItemsData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveCommand
extends SubCommand {
    private TreasureChest plugin;

    public RemoveCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.remove";
    }

    public boolean requiresPlayer() {
        return false;
    }

    public String getUsage() {
        return "<player> <id>";
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        block10: {
            ListedItemsData lid;
            if (args.remaining() != 2) {
                this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
                return true;
            }
            CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args.getNext(), true);
            if (target == null) {
                this.plugin.sendMessage(sender, "Unknown player!", true);
                return true;
            }
            int nr = args.getNext(-1);
            if (sender instanceof Player) {
                Player player = (Player)sender;
                lid = this.plugin.getData().getListedItems(player.getUniqueId());
            } else {
                lid = this.plugin.getData().getListedItems(null);
            }
            if (lid == null || !lid.getOwner().equals(target.getUniqueId())) {
                this.plugin.sendMessage(sender, "Nicht der gelistete Spieler", true);
                return true;
            }
            Integer key = lid.getItemDatabaseKey(nr);
            if (key == null) {
                this.plugin.sendMessage(sender, "Ung\u00fcltige ID", true);
                return true;
            }
            try {
                if (this.plugin.getDatabase().deleteItem(target.getUniqueId(), key)) {
                    PlayerTreasureChestContent content = this.plugin.getData().getChestContent(target.getUniqueId());
                    if (content != null && content.getLoadState() == PlayerTreasureChestContent.LoadState.LOADED) {
                        content.removeItem(key);
                    }
                    break block10;
                }
                this.plugin.sendMessage(sender, "Ung\u00fcltige ID", true);
                return true;
            }
            catch (SQLException e) {
                this.plugin.sendMessage(sender, ChatColor.DARK_RED + "Datenbankfehler");
                this.plugin.getLogger().log(Level.SEVERE, "Could not delete item " + key + " for " + target.getName() + ": " + e.getMessage(), e);
                return true;
            }
        }
        this.plugin.sendMessage(sender, "Der Preis wurde entfernt!");
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        if (args.remaining() == 1) {
            return null;
        }
        return List.of();
    }
}

