/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.listener;

import de.iani.cubesideutils.StringUtil;
import de.iani.treasurechest.OpenInventoryData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasurePayoutEvent;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ChestInventoryListener
implements Listener {
    private TreasureChest plugin;
    HashMap<Player, OpenInventoryData> openInventories = new HashMap();

    public ChestInventoryListener(TreasureChest plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChestOpen(PlayerInteractEvent e) {
        if (this.plugin.getChestLocation() == null) {
            return;
        }
        Block b = e.getClickedBlock();
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && b != null && b.getLocation().equals((Object)this.plugin.getChestLocation())) {
            e.setCancelled(true);
            if (!e.getPlayer().hasPermission("treasurechest.access")) {
                this.plugin.sendMessage((CommandSender)e.getPlayer(), "Du hast keinen Zugriff auf die Schatztruhe!");
                return;
            }
            if (this.openInventories.containsKey(e.getPlayer())) {
                return;
            }
            PlayerTreasureChestContent content = this.plugin.getData().getChestContent(e.getPlayer().getUniqueId());
            if (content != null && content.getLoadState() != PlayerTreasureChestContent.LoadState.LOADED) {
                content.loadAsync();
                return;
            }
            if (content == null || content.isEmpty()) {
                this.plugin.sendMessage((CommandSender)e.getPlayer(), "Deine Schatztruhe ist leer!");
                return;
            }
            Inventory inventory = this.plugin.getServer().createInventory(null, 54, "Schatztruhe");
            OpenInventoryData openInventory = new OpenInventoryData(b.getLocation(), inventory);
            int pos = 0;
            for (DatabaseTreasureChestItem item : content.getItems()) {
                if (pos < 54) {
                    ItemStack di = item.getDisplayItem().clone();
                    ItemMeta meta = di.getItemMeta();
                    ItemStack[] priceList = item.getPriceItems();
                    ArrayList<String> lore = new ArrayList<String>();
                    if (priceList != null) {
                        for (ItemStack stack : priceList) {
                            Damageable damageable;
                            StringBuilder t = new StringBuilder();
                            if (stack.getAmount() > 1) {
                                t.append(stack.getAmount()).append(" ");
                            }
                            t.append(StringUtil.capitalizeFirstLetter((String)stack.getType().name(), (boolean)true));
                            ItemMeta stackMeta = stack.getItemMeta();
                            if (stackMeta instanceof Damageable && (damageable = (Damageable)stackMeta).hasDamage()) {
                                t.append(':').append(damageable.getDamage());
                            }
                            if (stackMeta.hasDisplayName()) {
                                t.append(" (benanntes Item)");
                            }
                            lore.add(t.toString());
                        }
                    }
                    if (item.getPriceMoney() > 0) {
                        lore.add(this.plugin.formatMoney(item.getPriceMoney()));
                    }
                    meta.setLore(lore);
                    di.setItemMeta(meta);
                    inventory.setItem(pos, di);
                    openInventory.setItemAtPosition(pos, item.getId());
                }
                ++pos;
            }
            e.getPlayer().openInventory(inventory);
            this.openInventories.put(e.getPlayer(), openInventory);
            e.getPlayer().playSound(b.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 0.9f);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        OpenInventoryData openInventory = this.openInventories.get(event.getWhoClicked());
        if (openInventory == null) {
            return;
        }
        InventoryAction action = event.getAction();
        switch (action) {
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case PICKUP_ONE: {
                int money;
                int i;
                ItemStack[] temp;
                int priceMoney;
                event.setCancelled(true);
                if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || !(event.getWhoClicked() instanceof Player)) break;
                player = (Player)event.getWhoClicked();
                ItemStack[] playerInv = player.getInventory().getContents();
                playerInv = Arrays.copyOf(playerInv, 36);
                Inventory clonedPlayerInventory = Bukkit.createInventory(null, (int)36);
                clonedPlayerInventory.setContents(playerInv);
                PlayerTreasureChestContent content = this.plugin.getData().getChestContent(player.getUniqueId());
                Integer entryId = openInventory.getEntryAtPosition(event.getRawSlot());
                if (entryId == null) {
                    return;
                }
                DatabaseTreasureChestItem selectedItem = content.getItem(entryId);
                if (selectedItem == null) break;
                ItemStack[] priceList = selectedItem.getPriceItems();
                TreasurePayoutEvent payoutEvent = new TreasurePayoutEvent(player, priceList == null || priceList.length == 0 ? Collections.emptyList() : Arrays.asList(priceList), priceMoney = Math.max(selectedItem.getPriceMoney(), 0));
                int priceCount = payoutEvent.getItems().size();
                if (priceCount > 0) {
                    temp = new ItemStack[priceCount];
                    for (i = 0; i < priceCount; ++i) {
                        temp[i] = payoutEvent.getItems().get(i).clone();
                    }
                    if (this.addItemsToInventory(clonedPlayerInventory, temp) == null) {
                        this.plugin.sendMessage((CommandSender)player, "Du hast nicht gen\u00fcgend Platz in deinem Inventar!", true);
                        return;
                    }
                }
                this.plugin.getServer().getPluginManager().callEvent((Event)payoutEvent);
                if (payoutEvent.isCancelled()) {
                    return;
                }
                try {
                    if (!this.plugin.getDatabase().deleteItem(player.getUniqueId(), entryId)) {
                        return;
                    }
                }
                catch (SQLException e) {
                    this.plugin.sendMessage((CommandSender)player, ChatColor.DARK_RED + "Datenbankfehler");
                    this.plugin.getLogger().log(Level.SEVERE, "Could not delete item " + entryId + " for " + player.getUniqueId() + ": " + e.getMessage(), e);
                    return;
                }
                this.plugin.sendMessage((CommandSender)player, ChatColor.GRAY + "Du hast folgende Items erhalten:");
                if (priceCount > 0) {
                    temp = new ItemStack[priceCount];
                    for (i = 0; i < priceCount; ++i) {
                        temp[i] = payoutEvent.getItems().get(i).clone();
                    }
                    FilledInventory filledInventory = this.addItemsToInventory((Inventory)player.getInventory(), temp);
                    for (ItemStack stack : payoutEvent.getItems()) {
                        Damageable damageable;
                        StringBuilder t = new StringBuilder("  ");
                        if (stack.getAmount() > 1) {
                            t.append(stack.getAmount()).append(" ");
                        }
                        t.append(StringUtil.capitalizeFirstLetter((String)stack.getType().name(), (boolean)true));
                        ItemMeta stackMeta = stack.getItemMeta();
                        if (stackMeta instanceof Damageable && (damageable = (Damageable)stackMeta).hasDamage()) {
                            t.append(':').append(damageable.getDamage());
                        }
                        if (stackMeta.hasDisplayName()) {
                            t.append(" (").append(stackMeta.getDisplayName()).append(ChatColor.YELLOW).append(")");
                        }
                        this.plugin.sendMessage((CommandSender)player, t.toString());
                    }
                    if (filledInventory == FilledInventory.ShulkerBox) {
                        this.plugin.sendMessage((CommandSender)player, "Die Items wurden in eine leere Shulker-Kiste in deinem Inventar gelegt.");
                    }
                }
                if ((money = payoutEvent.getMoney()) > 0) {
                    this.plugin.giveMoney(player, money);
                    this.plugin.sendMessage((CommandSender)player, "  " + this.plugin.formatMoney(money));
                }
                player.playSound(event.getWhoClicked().getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                content.removeItem(entryId);
                openInventory.getInventory().setItem(event.getRawSlot(), null);
                openInventory.removeEntryAtPosition(event.getRawSlot());
                player.updateInventory();
            }
        }
        player = (Player)event.getWhoClicked();
        player.updateInventory();
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.openInventories.containsKey(event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        OpenInventoryData data = this.openInventories.remove(e.getPlayer());
        if (data != null) {
            ((Player)e.getPlayer()).playSound(data.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.5f, 0.9f);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.openInventories.remove(event.getPlayer());
    }

    private FilledInventory addItemsToInventory(Inventory inventory, ItemStack[] items) {
        int itemCount = 0;
        for (ItemStack itemStack : items) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            ++itemCount;
        }
        int inventorySpace = 0;
        for (ItemStack shulkerItem : inventory.getContents()) {
            if (shulkerItem != null && shulkerItem.getType() != Material.AIR) continue;
            ++inventorySpace;
        }
        if (inventorySpace >= itemCount) {
            inventory.addItem(items);
            return FilledInventory.PlayerInventory;
        }
        for (ItemStack inventoryItemStack : inventory.getContents()) {
            BlockStateMeta blockStateMeta;
            BlockState blockState;
            ItemMeta itemMeta;
            if (inventoryItemStack == null || !((itemMeta = inventoryItemStack.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            ItemStack[] shulkerContents = shulkerBox.getSnapshotInventory().getStorageContents();
            boolean shulkerEmpty = true;
            for (ItemStack shulkerItem : shulkerContents) {
                if (shulkerItem == null || shulkerItem.getType() == Material.AIR) continue;
                shulkerEmpty = false;
            }
            if (!shulkerEmpty) continue;
            shulkerBox.getSnapshotInventory().setStorageContents(items);
            blockStateMeta.setBlockState(blockState);
            inventoryItemStack.setItemMeta((ItemMeta)blockStateMeta);
            return FilledInventory.ShulkerBox;
        }
        return null;
    }

    private static enum FilledInventory {
        PlayerInventory,
        ShulkerBox;

    }
}

