/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import org.bukkit.inventory.ItemStack;

public class TreasureChestItem
implements Cloneable {
    private ItemStack displayItem;
    private ItemStack[] priceItems;
    private int priceMoney;

    public TreasureChestItem(ItemStack displayItem) {
        this.displayItem = displayItem;
    }

    public TreasureChestItem(ItemStack displayItem, ItemStack[] priceItems, int priceMoney) {
        this.displayItem = displayItem;
        this.priceItems = priceItems;
        this.priceMoney = priceMoney;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public ItemStack[] getPriceItems() {
        return this.priceItems;
    }

    public int getPriceMoney() {
        return this.priceMoney;
    }

    public void setPriceMoney(int amount) {
        this.priceMoney = amount;
    }

    public void addPriceItem(ItemStack item) {
        if (this.priceItems == null) {
            this.priceItems = new ItemStack[]{item};
        } else {
            ItemStack[] temp = this.priceItems;
            this.priceItems = new ItemStack[temp.length + 1];
            System.arraycopy(temp, 0, this.priceItems, 0, temp.length);
            this.priceItems[temp.length] = item;
        }
    }

    public TreasureChestItem clone() {
        try {
            TreasureChestItem el = (TreasureChestItem)super.clone();
            if (this.displayItem != null) {
                el.displayItem = this.displayItem.clone();
            }
            if (this.priceItems != null) {
                el.priceItems = new ItemStack[this.priceItems.length];
                for (int i = 0; i < this.priceItems.length; ++i) {
                    el.priceItems[i] = this.priceItems[i] != null ? this.priceItems[i].clone() : null;
                }
            }
            return el;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

