/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.entity.Player;

public class TreasureChestData {
    private HashMap<String, TreasureChestItem> namedItems = new HashMap();
    private HashMap<UUID, TreasureChestItem> activeItems = new HashMap();
    private HashMap<UUID, PlayerTreasureChestContent> loadedChests = new HashMap();
    private TreasureChest plugin;
    private File chestContentFolder;

    public TreasureChestData(TreasureChest plugin) {
        this.plugin = plugin;
        this.chestContentFolder = new File(this.plugin.getDataFolder(), "content");
        this.chestContentFolder.mkdirs();
    }

    public TreasureChestItem getNamedItem(String name) {
        return this.namedItems.get(name.toLowerCase().trim());
    }

    public TreasureChestItem getActiveItem(UUID playerUUID) {
        return this.activeItems.get(playerUUID);
    }

    public TreasureChestItem setActiveItem(UUID playerUUID, TreasureChestItem item) {
        if (item == null) {
            return this.removeActiveItem(playerUUID);
        }
        return this.activeItems.put(playerUUID, item);
    }

    public TreasureChestItem removeActiveItem(UUID playerUUID) {
        return this.activeItems.remove(playerUUID);
    }

    public PlayerTreasureChestContent getChestContentIfLoaded(UUID playerUUID) {
        return this.loadedChests.get(playerUUID);
    }

    public PlayerTreasureChestContent getChestContent(UUID playerUUID) {
        PlayerTreasureChestContent loaded = this.getChestContentIfLoaded(playerUUID);
        if (loaded != null) {
            return loaded;
        }
        return this.loadOrCreateChestContent(playerUUID);
    }

    private PlayerTreasureChestContent loadOrCreateChestContent(UUID playerUUID) {
        File playerData = new File(this.chestContentFolder, playerUUID.toString() + ".yml");
        PlayerTreasureChestContent content = new PlayerTreasureChestContent(this.plugin, playerData);
        this.loadedChests.put(playerUUID, content);
        return content;
    }

    public void doGC() {
        long t = System.currentTimeMillis();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            PlayerTreasureChestContent content = this.loadedChests.get(player.getUniqueId());
            if (content == null) continue;
            content.setOnline(t);
        }
        Iterator<PlayerTreasureChestContent> it = this.loadedChests.values().iterator();
        while (it.hasNext()) {
            if (it.next().isOnline(t)) continue;
            it.remove();
        }
    }
}

