/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.PlayerUUIDCache;
import de.iani.treasurechest.ChestInventoryListener;
import de.iani.treasurechest.PlayerEventListener;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChestAPI;
import de.iani.treasurechest.TreasureChestCommandExecutor;
import de.iani.treasurechest.TreasureChestData;
import de.iani.treasurechest.TreasureChestItem;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class TreasureChest
extends JavaPlugin
implements TreasureChestAPI {
    private TreasureChestData data;
    private Location chestLocation;
    private Random random;
    private boolean hasEconomy;
    private Economy economy;
    private PlayerUUIDCache playerUUIDCache;

    public void onEnable() {
        this.random = new Random();
        this.setupEconomy();
        this.playerUUIDCache = (PlayerUUIDCache)this.getServer().getPluginManager().getPlugin("PlayerUUIDCache");
        this.readConfig();
        this.data = new TreasureChestData(this);
        this.getCommand("treasurechest").setExecutor((CommandExecutor)new TreasureChestCommandExecutor(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ChestInventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                TreasureChest.this.createParticles();
            }
        }, 1L, 1L);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                TreasureChest.this.doGC();
            }
        }, 8456L, 140000L);
    }

    public PlayerUUIDCache getPlayerUUIDCache() {
        return this.playerUUIDCache;
    }

    @Override
    public boolean addItem(String player, ItemStack displayItem, ItemStack[] items, int money) {
        if (!this.getServer().isPrimaryThread()) {
            return false;
        }
        CachedPlayer id = this.playerUUIDCache.getPlayerFromNameOrUUID(player, true);
        if (id == null) {
            return false;
        }
        return this.addItem(id.getUUID(), displayItem, items, money);
    }

    @Override
    public boolean addItem(OfflinePlayer player, ItemStack displayItem, ItemStack[] items, int money) {
        if (!this.getServer().isPrimaryThread()) {
            return false;
        }
        return this.addItem(player.getUniqueId(), displayItem, items, money);
    }

    private boolean addItem(UUID player, ItemStack displayItem, ItemStack[] items, int money) {
        if (displayItem == null || displayItem.getAmount() == 0 || displayItem.getType() == Material.AIR) {
            return false;
        }
        ArrayList<ItemStack> copied = new ArrayList<ItemStack>();
        for (ItemStack is : items) {
            if (is == null || is.getAmount() <= 0 || is.getType() == Material.AIR) continue;
            copied.add(is.clone());
        }
        items = copied.toArray(new ItemStack[copied.size()]);
        PlayerTreasureChestContent content = this.getData().getChestContent(player);
        content.addItem(new TreasureChestItem(displayItem, items, money));
        return true;
    }

    protected void doGC() {
        this.data.doGC();
    }

    private void readConfig() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection section = config.getConfigurationSection("chestLocation");
        if (section != null) {
            World world;
            String worldName = section.getString("world");
            int x = section.getInt("x");
            int y = section.getInt("y");
            int z = section.getInt("z");
            if (worldName != null && (world = this.getServer().getWorld(worldName)) != null) {
                this.chestLocation = new Location(world, (double)x, (double)y, (double)z);
            }
        }
    }

    public void saveConfig() {
        FileConfiguration config = this.getConfig();
        if (this.chestLocation == null || this.chestLocation.getWorld() == null) {
            config.set("chestLocation", null);
        } else {
            ConfigurationSection section = config.getConfigurationSection("chestLocation");
            if (section == null) {
                section = config.createSection("chestLocation");
            }
            section.set("world", (Object)this.chestLocation.getWorld().getName());
            section.set("x", (Object)this.chestLocation.getBlockX());
            section.set("y", (Object)this.chestLocation.getBlockY());
            section.set("z", (Object)this.chestLocation.getBlockZ());
        }
        super.saveConfig();
    }

    public TreasureChestData getData() {
        return this.data;
    }

    public Location getChestLocation() {
        return this.chestLocation;
    }

    protected void createParticles() {
        if (this.random.nextInt(10) == 0 && this.chestLocation != null && this.chestLocation.getWorld() != null) {
            Location playerLocation = new Location(null, 0.0, 0.0, 0.0);
            for (Player player : this.getServer().getOnlinePlayers()) {
                double dz;
                double dy;
                if (player.getWorld() != this.chestLocation.getWorld()) continue;
                player.getLocation(playerLocation);
                double dx = playerLocation.getX() - this.chestLocation.getX();
                double dsquared = dx * dx + (dy = playerLocation.getY() - this.chestLocation.getY()) * dy + (dz = playerLocation.getZ() - this.chestLocation.getZ()) * dz;
                if (!(dsquared < 256.0) || this.data.getChestContent(player.getUniqueId()).isEmpty()) continue;
                player.playEffect(this.chestLocation, Effect.MOBSPAWNER_FLAMES, null);
            }
        }
    }

    public void sendMessage(CommandSender p, String text) {
        this.sendMessage(p, text, false);
    }

    public void sendMessage(CommandSender p, String text, boolean error) {
        p.sendMessage(ChatColor.BLUE + "[TC] " + (error ? ChatColor.DARK_RED : ChatColor.YELLOW) + text);
    }

    public void setChestLocation(Location location) {
        this.chestLocation = location;
        this.saveConfig();
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null && economyProvider.getProvider() != null) {
                this.economy = (Economy)economyProvider.getProvider();
                this.hasEconomy = true;
            } else {
                this.getLogger().warning("Kein Economy-Plugin! Es k\u00f6nnen keine Preisgelder ausgezahlt werden!");
            }
        }
        catch (Throwable e) {
            this.getLogger().warning("Vault nicht gefunden! Es k\u00f6nnen keine Preisgelder ausgezahlt werden!");
        }
    }

    public boolean hasEconomy() {
        return this.hasEconomy;
    }

    public void giveMoney(Player player, int amount) {
        if (this.hasEconomy) {
            try {
                this.economy.depositPlayer((OfflinePlayer)player, (double)amount);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "Error paying money", e);
            }
        }
    }

    public String formatMoney(int amount) {
        if (this.hasEconomy) {
            try {
                return this.economy.format((double)amount);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "Error formating money", e);
            }
        }
        return Integer.toString(amount);
    }

    public static String capitalize(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            if (cap[i] == '_') {
                if (replaceUnderscores) {
                    cap[i] = 32;
                }
                lastSpace = true;
                continue;
            }
            if (cap[i] >= '0' && cap[i] <= '9') {
                lastSpace = true;
                continue;
            }
            cap[i] = lastSpace ? Character.toUpperCase(cap[i]) : Character.toLowerCase(cap[i]);
            lastSpace = false;
        }
        return new String(cap);
    }
}

