/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.destroystokyo.paper.event.profile.FillProfileEvent;
import com.destroystokyo.paper.event.profile.PreFillProfileEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.CachedPlayerProfile;
import de.iani.playerUUIDCache.PlayerUUIDCache;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PaperProfilePropertiesAPIListener
implements Listener {
    private final PlayerUUIDCache plugin;

    public PaperProfilePropertiesAPIListener(PlayerUUIDCache plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPreFillProfile(PreFillProfileEvent e) {
        CachedPlayer cached;
        PlayerProfile profile = e.getPlayerProfile();
        UUID uuid = profile.getId();
        if (uuid == null && (cached = this.plugin.getPlayer(profile.getName())) != null) {
            uuid = cached.getUUID();
        }
        if (uuid == null) {
            this.plugin.getLogger().info("PreFillProfile: UUID is null for " + profile.getName());
            return;
        }
        CachedPlayerProfile cachedProfile = this.plugin.getPlayerProfile(uuid);
        if (cachedProfile != null) {
            profile.setProperties(cachedProfile.getProperties());
        }
    }

    @EventHandler
    public void onFillProfile(FillProfileEvent e) {
        CachedPlayer cached;
        PlayerProfile profile = e.getPlayerProfile();
        UUID uuid = profile.getId();
        if (uuid == null && (cached = this.plugin.getPlayer(profile.getName())) != null) {
            uuid = cached.getUUID();
        }
        if (uuid == null) {
            this.plugin.getLogger().info("PreFillProfile: UUID is null for " + profile.getName());
            return;
        }
        long now = System.currentTimeMillis();
        this.plugin.updateProfileProperties(true, new CachedPlayerProfile(uuid, profile.getProperties(), now, now));
    }
}

