/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import de.iani.playerUUIDCache.PlayerUUIDCache;
import de.iani.playerUUIDCache.SQLConfig;
import org.bukkit.configuration.file.FileConfiguration;

public class PluginConfig {
    private final long memoryCacheExpirationTime;
    private final long nameHistoryCacheExpirationTime;
    private final boolean useSQL;
    private final SQLConfig sqlConfig;

    public PluginConfig(PlayerUUIDCache plugin) {
        FileConfiguration config = plugin.getConfig();
        if (!config.contains("nameHistoryCacheExpirationTime", true)) {
            config.set("nameHistoryCacheExpirationTime", (Object)2592000000L);
            plugin.saveConfig();
        }
        this.useSQL = config.getBoolean("useSQL");
        this.memoryCacheExpirationTime = !this.useSQL ? -1L : config.getLong("memoryCacheExpirationTime");
        this.nameHistoryCacheExpirationTime = config.getLong("nameHistoryCacheExpirationTime", 2592000000L);
        this.sqlConfig = this.useSQL ? new SQLConfig(config.getConfigurationSection("database")) : null;
    }

    public long getMemoryCacheExpirationTime() {
        return this.memoryCacheExpirationTime;
    }

    public long getNameHistoryCacheExpirationTime() {
        return this.nameHistoryCacheExpirationTime;
    }

    public boolean useSQL() {
        return this.useSQL;
    }

    public SQLConfig getSqlConfig() {
        return this.sqlConfig;
    }
}

