/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class CachedPlayer
implements OfflinePlayer {
    private final UUID uuid;
    private final String name;
    private final long lastSeen;
    private final long cacheLoadTime;

    public CachedPlayer(UUID uuid, String name, long lastSeen, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)name);
        this.uuid = uuid;
        this.name = name;
        this.lastSeen = lastSeen;
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getLastLogin() {
        return this.lastSeen;
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public int hashCode() {
        return this.name.hashCode() + this.uuid.hashCode() + (int)this.lastSeen;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != CachedPlayer.class) {
            return false;
        }
        CachedPlayer other = (CachedPlayer)obj;
        return this.name.equalsIgnoreCase(other.name) && this.uuid.equals(other.uuid) && this.lastSeen == other.lastSeen;
    }

    public boolean isOp() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isOp();
    }

    public void setOp(boolean value) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setOp(value);
    }

    public Map<String, Object> serialize() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).serialize();
    }

    public boolean isOnline() {
        return Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean isBanned() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isBanned();
    }

    public boolean isWhitelisted() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isWhitelisted();
    }

    public void setWhitelisted(boolean value) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setWhitelisted(value);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public long getFirstPlayed() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getFirstPlayed();
    }

    public long getLastPlayed() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getLastPlayed();
    }

    public boolean hasPlayedBefore() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).hasPlayedBefore();
    }

    public Location getBedSpawnLocation() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getBedSpawnLocation();
    }
}

