/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.LoggingUtil;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class ScaffoldingLogging
extends LoggingListener {
    private static final long MAX_SCAFFOLDING_LOG_TIME_MS = 2000L;
    private static final EnumSet<BlockFace> NEIGHBOURS_SIDES_AND_UP = EnumSet.of(BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private static final EnumSet<BlockFace> NEIGHBOURS_SIDES_AND_BELOW = EnumSet.of(BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private final ArrayDeque<ScaffoldingBreaker> scaffoldingBreakersList = new ArrayDeque();
    private final HashMap<Location, ScaffoldingBreaker> scaffoldingBreakersByLocation = new HashMap();
    private final HashMap<Location, Actor> scaffoldingPlacersByLocation = new HashMap();

    public ScaffoldingLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        Material type;
        Block block = event.getBlock();
        if (Config.isLogging(block.getWorld(), Logging.SCAFFOLDING) && (type = block.getType()) == Material.SCAFFOLDING) {
            Actor actor = this.scaffoldingPlacersByLocation.get(block.getLocation());
            this.cleanupScaffoldingBreakers();
            if (actor == null) {
                actor = this.getScaffoldingBreaker(block);
                if (actor != null) {
                    for (BlockFace dir : NEIGHBOURS_SIDES_AND_UP) {
                        Block otherBlock = block.getRelative(dir);
                        if (otherBlock.getType() != Material.SCAFFOLDING) continue;
                        this.addScaffoldingBreaker(actor, otherBlock);
                    }
                } else {
                    actor = new Actor("ScaffoldingFall");
                }
            }
            this.consumer.queueBlockReplace(actor, block.getState(), event.getNewState());
            LoggingUtil.smartLogFallables(this.consumer, actor, block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (Config.isLogging(block.getWorld(), Logging.SCAFFOLDING)) {
            this.cleanupScaffoldingBreakers();
            if (block.getType() == Material.SCAFFOLDING) {
                for (BlockFace dir : NEIGHBOURS_SIDES_AND_UP) {
                    Block otherBlock = block.getRelative(dir);
                    if (otherBlock.getType() != Material.SCAFFOLDING) continue;
                    this.addScaffoldingBreaker(Actor.actorFromEntity((Entity)event.getPlayer()), otherBlock);
                }
            } else {
                Block otherBlock = block.getRelative(BlockFace.UP);
                if (otherBlock.getType() == Material.SCAFFOLDING) {
                    this.addScaffoldingBreaker(Actor.actorFromEntity((Entity)event.getPlayer()), otherBlock);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (Config.isLogging(block.getWorld(), Logging.SCAFFOLDING)) {
            this.cleanupScaffoldingBreakers();
            if (block.getType() == Material.SCAFFOLDING) {
                this.scaffoldingPlacersByLocation.put(block.getLocation(), Actor.actorFromEntity((Entity)event.getPlayer()));
            }
        }
    }

    public void addScaffoldingBreaker(Actor actor, Block block) {
        ScaffoldingBreaker breaker = new ScaffoldingBreaker(actor, block.getLocation());
        this.scaffoldingBreakersList.addLast(breaker);
        this.scaffoldingBreakersByLocation.put(breaker.getLocation(), breaker);
    }

    private void cleanupScaffoldingBreakers() {
        if (!this.scaffoldingPlacersByLocation.isEmpty()) {
            this.scaffoldingPlacersByLocation.clear();
        }
        if (!this.scaffoldingBreakersList.isEmpty()) {
            long time = System.currentTimeMillis() - 2000L;
            while (!this.scaffoldingBreakersList.isEmpty() && this.scaffoldingBreakersList.getFirst().getTime() < time) {
                ScaffoldingBreaker breaker = this.scaffoldingBreakersList.removeFirst();
                this.scaffoldingBreakersByLocation.remove(breaker.getLocation(), breaker);
            }
        }
    }

    private Actor getScaffoldingBreaker(Block block) {
        if (this.scaffoldingBreakersList.isEmpty()) {
            return null;
        }
        ScaffoldingBreaker breaker = this.scaffoldingBreakersByLocation.get(block.getLocation());
        if (breaker != null) {
            return breaker.getActor();
        }
        ArrayDeque<Block> front = new ArrayDeque<Block>();
        HashSet<Block> frontAndDone = new HashSet<Block>();
        front.addLast(block);
        frontAndDone.add(block);
        while (!front.isEmpty()) {
            Block current = (Block)front.removeFirst();
            Location loc = current.getLocation();
            breaker = this.scaffoldingBreakersByLocation.get(loc);
            if (breaker != null) {
                return breaker.getActor();
            }
            for (BlockFace dir : NEIGHBOURS_SIDES_AND_BELOW) {
                Block otherBlock = current.getRelative(dir);
                if (frontAndDone.contains(otherBlock) || otherBlock.getType() != Material.SCAFFOLDING) continue;
                front.addLast(otherBlock);
                frontAndDone.add(otherBlock);
            }
        }
        return null;
    }

    class ScaffoldingBreaker {
        protected final Actor actor;
        protected final long time;
        protected final Location location;

        public ScaffoldingBreaker(Actor actor, Location location) {
            this.actor = actor;
            this.location = location;
            this.time = System.currentTimeMillis();
        }

        public Actor getActor() {
            return this.actor;
        }

        public Location getLocation() {
            return this.location;
        }

        public long getTime() {
            return this.time;
        }
    }
}

