/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.componentwrapper;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.componentwrapper.ChatColor;
import de.diddiz.LogBlock.componentwrapper.Click;
import de.diddiz.LogBlock.componentwrapper.Component;
import de.diddiz.LogBlock.componentwrapper.Hover;
import de.diddiz.LogBlock.componentwrapper.ItemHover;
import de.diddiz.LogBlock.componentwrapper.RunCommandClick;
import de.diddiz.LogBlock.componentwrapper.TextComponent;
import de.diddiz.LogBlock.componentwrapper.TextHover;
import de.diddiz.LogBlock.util.MessagingUtil;
import de.diddiz.LogBlock.util.TypeColor;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Components {
    private static final boolean HAS_ADVENTURE;
    private static final Component EMPTY;
    private static final Component SPACE;

    public static Component empty() {
        return EMPTY;
    }

    public static Component space() {
        return SPACE;
    }

    public static TextComponent text(String text) {
        return Components.text(text, null, new Component[0]);
    }

    public static TextComponent text(String text, ChatColor color, Component ... children) {
        return Components.text(text, color, null, null, children);
    }

    public static TextComponent text(String text, ChatColor color, Hover hover, Click click, Component ... children) {
        return new TextComponent(text, color, hover, click, children);
    }

    public static void sendTo(CommandSender target, Component message) {
        if (HAS_ADVENTURE) {
            AdventureSender.sendTo(target, message);
        } else {
            BungeeSender.sendTo(target, message);
        }
    }

    public static Component fromLegacy(String text) {
        BaseComponent component = net.md_5.bungee.api.chat.TextComponent.fromLegacy((String)text);
        return BungeeSender.toComponent(component);
    }

    public static String toPlainText(Component component) {
        return BungeeSender.toBungee(component).toPlainText();
    }

    static {
        EMPTY = Components.text("");
        SPACE = Components.text(" ");
        boolean hasAdventure = false;
        try {
            Class<Player> audienceInterface = Class.forName("net.kyori.adventure.audience.Audience");
            hasAdventure = audienceInterface.isAssignableFrom(Player.class);
            LogBlock.getInstance().getLogger().info("Using adventure components");
        }
        catch (Throwable t) {
            LogBlock.getInstance().getLogger().info("Using bungee components");
        }
        HAS_ADVENTURE = hasAdventure;
    }

    private static class AdventureSender {
        private static final Map<ChatColor, TextColor> colorMap = new HashMap<ChatColor, TextColor>();

        private AdventureSender() {
        }

        public static void sendTo(CommandSender target, Component message) {
            Audience targetAudience = (Audience)target;
            targetAudience.sendMessage(AdventureSender.toAdventure(message));
        }

        private static net.kyori.adventure.text.Component toAdventure(Component message) {
            net.kyori.adventure.text.TextComponent result = net.kyori.adventure.text.Component.text((String)((TextComponent)message).getText(), (TextColor)AdventureSender.toAdventure(message.getColor()));
            if (!message.getChildren().isEmpty()) {
                result = result.children(message.getChildren().parallelStream().map(AdventureSender::toAdventure).toList());
            }
            if (message.getHover() != null) {
                result = result.hoverEvent(AdventureSender.toAdventure(message.getHover()));
            }
            if (message.getClick() != null) {
                result = result.clickEvent(AdventureSender.toAdventure(message.getClick()));
            }
            return result;
        }

        @Nullable
        private static net.kyori.adventure.text.event.ClickEvent toAdventure(Click click) {
            if (click instanceof RunCommandClick) {
                RunCommandClick run = (RunCommandClick)click;
                return net.kyori.adventure.text.event.ClickEvent.runCommand((String)run.getCommand());
            }
            return null;
        }

        private static HoverEventSource<?> toAdventure(Hover hover) {
            if (hover instanceof TextHover) {
                TextHover text = (TextHover)hover;
                return net.kyori.adventure.text.event.HoverEvent.showText((net.kyori.adventure.text.Component)AdventureSender.toAdventure(text.getText()));
            }
            if (hover instanceof ItemHover) {
                ItemHover item = (ItemHover)hover;
                return (HoverEventSource)item.getItem();
            }
            return null;
        }

        private static TextColor toAdventure(ChatColor color) {
            return color == null ? null : colorMap.getOrDefault(color, TextColor.color((int)color.getColor()));
        }

        static {
            colorMap.put(ChatColor.BLACK, (TextColor)NamedTextColor.BLACK);
            colorMap.put(ChatColor.DARK_BLUE, (TextColor)NamedTextColor.DARK_BLUE);
            colorMap.put(ChatColor.DARK_GREEN, (TextColor)NamedTextColor.DARK_GREEN);
            colorMap.put(ChatColor.DARK_AQUA, (TextColor)NamedTextColor.DARK_AQUA);
            colorMap.put(ChatColor.DARK_RED, (TextColor)NamedTextColor.DARK_RED);
            colorMap.put(ChatColor.DARK_PURPLE, (TextColor)NamedTextColor.DARK_PURPLE);
            colorMap.put(ChatColor.GOLD, (TextColor)NamedTextColor.GOLD);
            colorMap.put(ChatColor.GRAY, (TextColor)NamedTextColor.GRAY);
            colorMap.put(ChatColor.DARK_GRAY, (TextColor)NamedTextColor.DARK_GRAY);
            colorMap.put(ChatColor.BLUE, (TextColor)NamedTextColor.BLUE);
            colorMap.put(ChatColor.GREEN, (TextColor)NamedTextColor.GREEN);
            colorMap.put(ChatColor.AQUA, (TextColor)NamedTextColor.AQUA);
            colorMap.put(ChatColor.RED, (TextColor)NamedTextColor.RED);
            colorMap.put(ChatColor.LIGHT_PURPLE, (TextColor)NamedTextColor.LIGHT_PURPLE);
            colorMap.put(ChatColor.YELLOW, (TextColor)NamedTextColor.YELLOW);
            colorMap.put(ChatColor.WHITE, (TextColor)NamedTextColor.WHITE);
        }
    }

    private static class BungeeSender {
        private static final Map<ChatColor, net.md_5.bungee.api.ChatColor> colorMap = new HashMap<ChatColor, net.md_5.bungee.api.ChatColor>();
        private static final Map<net.md_5.bungee.api.ChatColor, ChatColor> inverseColorMap;

        private BungeeSender() {
        }

        public static void sendTo(CommandSender target, Component message) {
            target.spigot().sendMessage(BungeeSender.toBungee(message));
        }

        private static BaseComponent toBungee(Component message) {
            net.md_5.bungee.api.chat.TextComponent result = new net.md_5.bungee.api.chat.TextComponent(((TextComponent)message).getText());
            result.setColor(BungeeSender.toBungee(message.getColor()));
            if (!message.getChildren().isEmpty()) {
                for (Component child : message.getChildren()) {
                    result.addExtra(BungeeSender.toBungee(child));
                }
            }
            if (message.getHover() != null) {
                result.setHoverEvent(BungeeSender.toBungee(message.getHover()));
            }
            if (message.getClick() != null) {
                result.setClickEvent(BungeeSender.toBungee(message.getClick()));
            }
            return result;
        }

        private static ClickEvent toBungee(Click click) {
            if (click instanceof RunCommandClick) {
                RunCommandClick run = (RunCommandClick)click;
                return new ClickEvent(ClickEvent.Action.RUN_COMMAND, run.getCommand());
            }
            return null;
        }

        private static HoverEvent toBungee(Hover hover) {
            if (hover instanceof TextHover) {
                TextHover text = (TextHover)hover;
                return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(BungeeSender.toBungee(text.getText()))});
            }
            if (hover instanceof ItemHover) {
                ItemHover item = (ItemHover)hover;
                ItemStack stack = item.getItem();
                try {
                    String itemTag = stack.getItemMeta().getAsString();
                    return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new Content[]{new Item(stack.getType().getKey().toString(), 1, itemTag != null ? ItemTag.ofNbt((String)itemTag) : null)});
                }
                catch (Exception e) {
                    LogBlock.getInstance().getLogger().log(Level.SEVERE, "Failed to convert Itemstack to JSON", e);
                    return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new BaseComponent[]{BungeeSender.toBungee(MessagingUtil.createTextComponentWithColor("Error", TypeColor.ERROR.getColor()))})});
                }
            }
            return null;
        }

        private static net.md_5.bungee.api.ChatColor toBungee(ChatColor color) {
            return color == null ? null : colorMap.getOrDefault(color, net.md_5.bungee.api.ChatColor.of((Color)new Color(color.getColor())));
        }

        public static Component toComponent(BaseComponent component) {
            Component result = Components.text(((net.md_5.bungee.api.chat.TextComponent)component).getText(), BungeeSender.toComponent(component.getColorRaw()), new Component[0]);
            if (component.getExtra() != null) {
                for (BaseComponent child : component.getExtra()) {
                    result = ((Component)result).append(BungeeSender.toComponent(child));
                }
            }
            return result;
        }

        private static ChatColor toComponent(net.md_5.bungee.api.ChatColor color) {
            return color == null ? null : inverseColorMap.getOrDefault(color, ChatColor.from(color.getColor()));
        }

        static {
            colorMap.put(ChatColor.BLACK, net.md_5.bungee.api.ChatColor.BLACK);
            colorMap.put(ChatColor.DARK_BLUE, net.md_5.bungee.api.ChatColor.DARK_BLUE);
            colorMap.put(ChatColor.DARK_GREEN, net.md_5.bungee.api.ChatColor.DARK_GREEN);
            colorMap.put(ChatColor.DARK_AQUA, net.md_5.bungee.api.ChatColor.DARK_AQUA);
            colorMap.put(ChatColor.DARK_RED, net.md_5.bungee.api.ChatColor.DARK_RED);
            colorMap.put(ChatColor.DARK_PURPLE, net.md_5.bungee.api.ChatColor.DARK_PURPLE);
            colorMap.put(ChatColor.GOLD, net.md_5.bungee.api.ChatColor.GOLD);
            colorMap.put(ChatColor.GRAY, net.md_5.bungee.api.ChatColor.GRAY);
            colorMap.put(ChatColor.DARK_GRAY, net.md_5.bungee.api.ChatColor.DARK_GRAY);
            colorMap.put(ChatColor.BLUE, net.md_5.bungee.api.ChatColor.BLUE);
            colorMap.put(ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GREEN);
            colorMap.put(ChatColor.AQUA, net.md_5.bungee.api.ChatColor.AQUA);
            colorMap.put(ChatColor.RED, net.md_5.bungee.api.ChatColor.RED);
            colorMap.put(ChatColor.LIGHT_PURPLE, net.md_5.bungee.api.ChatColor.LIGHT_PURPLE);
            colorMap.put(ChatColor.YELLOW, net.md_5.bungee.api.ChatColor.YELLOW);
            colorMap.put(ChatColor.WHITE, net.md_5.bungee.api.ChatColor.WHITE);
            inverseColorMap = new HashMap<net.md_5.bungee.api.ChatColor, ChatColor>();
            for (Map.Entry<ChatColor, net.md_5.bungee.api.ChatColor> e : colorMap.entrySet()) {
                inverseColorMap.put(e.getValue(), e.getKey());
            }
        }
    }
}

