/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.EntityTypeConverter;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class EntityChange
implements LookupCacheElement {
    public final long id;
    public final long date;
    public final Location loc;
    public final Actor actor;
    public final EntityType type;
    public final int entityId;
    public final UUID entityUUID;
    public final EntityChangeType changeType;
    public final byte[] data;

    public EntityChange(long date, Location loc, Actor actor, EntityType type, UUID entityid, EntityChangeType changeType, byte[] data) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.actor = actor;
        this.type = type;
        this.entityId = -1;
        this.entityUUID = entityid;
        this.changeType = changeType;
        this.data = data;
    }

    public EntityChange(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? (long)rs.getInt("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.actor = p.needPlayer ? new Actor(rs) : null;
        this.type = p.needType ? EntityTypeConverter.getEntityType(rs.getInt("entitytypeid")) : null;
        this.entityId = p.needData ? rs.getInt("entityid") : 0;
        this.entityUUID = p.needData ? UUID.fromString(rs.getString("entityuuid")) : null;
        this.changeType = p.needType ? EntityChangeType.valueOf(rs.getInt("action")) : null;
        this.data = p.needData ? rs.getBytes("data") : null;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.date > 0L) {
            msg.append(Config.formatter.format(this.date)).append(" ");
        }
        if (this.actor != null) {
            msg.append(this.actor.getName()).append(" ");
        }
        if (this.changeType == EntityChangeType.CREATE) {
            msg.append("created ");
        } else if (this.changeType == EntityChangeType.KILL) {
            boolean living = this.type != null && LivingEntity.class.isAssignableFrom(this.type.getEntityClass()) && !ArmorStand.class.isAssignableFrom(this.type.getDeclaringClass());
            msg.append(living ? "killed " : "destroyed ");
        } else if (this.changeType == EntityChangeType.ADDEQUIP) {
            ItemStack stack;
            YamlConfiguration conf = Utils.deserializeYamlConfiguration(this.data);
            ItemStack itemStack = stack = conf == null ? null : conf.getItemStack("item");
            if (stack == null) {
                msg.append("added an item to ");
            } else {
                msg.append("added " + stack.getType() + " to ");
            }
        } else if (this.changeType == EntityChangeType.REMOVEEQUIP) {
            ItemStack stack;
            YamlConfiguration conf = Utils.deserializeYamlConfiguration(this.data);
            ItemStack itemStack = stack = conf == null ? null : conf.getItemStack("item");
            if (stack == null) {
                msg.append("removed an item from ");
            } else {
                msg.append("removed " + stack.getType() + " from ");
            }
        } else if (this.changeType == EntityChangeType.MODIFY) {
            msg.append("modified ");
        } else {
            msg.append("did an unknown action to ");
        }
        if (this.type != null) {
            msg.append(this.type.name());
        } else {
            msg.append("an unknown entity");
        }
        if (this.loc != null) {
            msg.append(" at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ());
        }
        return msg.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public static enum EntityChangeType {
        CREATE,
        KILL,
        MODIFY,
        ADDEQUIP,
        REMOVEEQUIP;

        private static EntityChangeType[] values;

        public static EntityChangeType valueOf(int ordinal) {
            return values[ordinal];
        }

        static {
            values = EntityChangeType.values();
        }
    }
}

