/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.util.BukkitUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class Actor {
    final String name;
    final String UUID;
    final Location blockLocation;

    public int hashCode() {
        return this.UUID != null ? this.UUID.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Actor other = (Actor)obj;
        return this.UUID == null ? other.UUID == null : this.UUID.equals(other.UUID);
    }

    public Actor(String name, String UUID2) {
        this.name = name;
        this.UUID = UUID2 == null ? "unknown" : (UUID2.length() > 36 ? UUID2.substring(0, 36) : UUID2);
        this.blockLocation = null;
    }

    public Actor(String name, String UUID2, Block block) {
        this.name = name;
        this.UUID = UUID2 == null ? "unknown" : (UUID2.length() > 36 ? UUID2.substring(0, 36) : UUID2);
        this.blockLocation = block == null ? null : block.getLocation();
    }

    public Actor(String name, UUID UUID2) {
        this.name = name;
        this.UUID = UUID2.toString();
        this.blockLocation = null;
    }

    public Actor(String name, UUID UUID2, Block block) {
        this.name = name;
        this.UUID = UUID2.toString();
        this.blockLocation = block == null ? null : block.getLocation();
    }

    public Actor(String name) {
        this(name, Actor.generateUUID(name));
    }

    public Actor(String name, Block block) {
        this(name, Actor.generateUUID(name), block);
    }

    public Actor(ResultSet rs) throws SQLException {
        this(rs.getString("playername"), rs.getString("UUID"));
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.UUID;
    }

    public Location getBlockLocation() {
        return this.blockLocation;
    }

    public static Actor actorFromEntity(Entity entity) {
        ProjectileSource shooter;
        if (entity instanceof Player) {
            return new Actor(BukkitUtils.entityName(entity), entity.getUniqueId());
        }
        if (entity instanceof Projectile && (shooter = ((Projectile)entity).getShooter()) != null) {
            return Actor.actorFromProjectileSource(shooter);
        }
        return new Actor(BukkitUtils.entityName(entity));
    }

    public static Actor actorFromEntity(EntityType entity) {
        return new Actor(entity.name());
    }

    public static Actor actorFromProjectileSource(ProjectileSource psource) {
        if (psource instanceof Entity) {
            return Actor.actorFromEntity((Entity)psource);
        }
        if (psource instanceof BlockProjectileSource) {
            return new Actor(((BlockProjectileSource)psource).getBlock().getType().toString());
        }
        return new Actor(psource.toString());
    }

    public static Actor actorFromString(String actorName) {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player p : players) {
            if (!p.getName().equalsIgnoreCase(actorName)) continue;
            return Actor.actorFromEntity((Entity)p);
        }
        return new Actor(actorName);
    }

    public static boolean isValidUUID(String uuid) {
        try {
            java.util.UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String generateUUID(String name) {
        return "log_" + name;
    }
}

