/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.worldedit;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CuboidRegion
implements Cloneable {
    private org.bukkit.World world;
    private BlockVector min = new BlockVector();
    private BlockVector max = new BlockVector();

    public CuboidRegion(org.bukkit.World world, BlockVector first, BlockVector second) {
        this.world = world;
        this.min.setX(Math.min(first.getBlockX(), second.getBlockX()));
        this.min.setY(Math.min(first.getBlockY(), second.getBlockY()));
        this.min.setZ(Math.min(first.getBlockZ(), second.getBlockZ()));
        this.max.setX(Math.max(first.getBlockX(), second.getBlockX()));
        this.max.setY(Math.max(first.getBlockY(), second.getBlockY()));
        this.max.setZ(Math.max(first.getBlockZ(), second.getBlockZ()));
    }

    public static CuboidRegion fromPlayerSelection(Player player, Plugin worldEditPlugin) {
        Region selection;
        LocalSession session = ((WorldEditPlugin)worldEditPlugin).getSession(player);
        org.bukkit.World world = player.getWorld();
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        if (!weWorld.equals((Object)session.getSelectionWorld())) {
            throw new IllegalArgumentException("No selection defined");
        }
        try {
            selection = session.getSelection(weWorld);
        }
        catch (IncompleteRegionException e) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (selection == null) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (!(selection instanceof com.sk89q.worldedit.regions.CuboidRegion)) {
            throw new IllegalArgumentException("You have to define a cuboid selection");
        }
        BlockVector3 min = selection.getMinimumPoint();
        BlockVector3 max = selection.getMaximumPoint();
        return new CuboidRegion(world, new BlockVector(min.getBlockX(), min.getBlockY(), min.getBlockZ()), new BlockVector(max.getBlockX(), max.getBlockY(), max.getBlockZ()));
    }

    public static CuboidRegion fromCorners(org.bukkit.World world, Location first, Location second) {
        return new CuboidRegion(world, new BlockVector(first.getBlockX(), first.getBlockY(), first.getBlockZ()), new BlockVector(second.getBlockX(), second.getBlockY(), second.getBlockZ()));
    }

    public org.bukkit.World getWorld() {
        return this.world;
    }

    public BlockVector getMinimumPoint() {
        return this.min;
    }

    public BlockVector getMaximumPoint() {
        return this.max;
    }

    public int getSizeX() {
        return this.max.getBlockX() - this.min.getBlockX() + 1;
    }

    public int getSizeZ() {
        return this.max.getBlockZ() - this.min.getBlockZ() + 1;
    }

    public CuboidRegion clone() {
        try {
            CuboidRegion clone = (CuboidRegion)super.clone();
            clone.min = this.min.clone();
            clone.max = this.max.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("CuboidRegion should be cloneable", ex);
        }
    }
}

