/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Location;
import org.bukkit.Material;

public class Kill
implements LookupCacheElement {
    final long id;
    final long date;
    public final Location loc;
    final String killerName;
    final String victimName;
    final int weapon;

    public Kill(String killerName, String victimName, int weapon, Location loc) {
        this.id = 0L;
        this.date = System.currentTimeMillis() / 1000L;
        this.loc = loc;
        this.killerName = killerName;
        this.victimName = victimName;
        this.weapon = weapon;
    }

    public Kill(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? (long)rs.getInt("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.killerName = p.needKiller ? rs.getString("killer") : null;
        this.victimName = p.needVictim ? rs.getString("victim") : null;
        this.weapon = p.needWeapon ? rs.getInt("weapon") : 0;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.date > 0L) {
            msg.append(Config.formatter.format(this.date)).append(" ");
        }
        msg.append(this.killerName).append(" killed ").append(this.victimName);
        if (this.loc != null) {
            msg.append(" at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ());
        }
        String weaponName = this.prettyItemName(MaterialConverter.getMaterial(this.weapon));
        msg.append(" with " + weaponName);
        return msg.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public String prettyItemName(Material t) {
        if (t == null || BukkitUtils.isEmpty(t)) {
            return "fist";
        }
        return t.toString().replace('_', ' ').toLowerCase();
    }
}

