/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class LoggingUtil {
    public static void smartLogBlockPlace(Consumer consumer, Actor actor, BlockState replaced, BlockState placed) {
        int initialy;
        int y;
        Location loc = replaced.getLocation();
        if (!placed.getType().hasGravity() || !BukkitUtils.canDirectlyFallIn(replaced.getBlock().getRelative(BlockFace.DOWN).getType())) {
            if (BukkitUtils.isEmpty(replaced.getType())) {
                consumer.queueBlockPlace(actor, placed);
            } else {
                consumer.queueBlockReplace(actor, replaced, placed);
            }
            return;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        for (y = initialy = loc.getBlockY(); y > 0 && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
        }
        if (initialy != y && !BukkitUtils.isEmpty(replaced.getType())) {
            consumer.queueBlockBreak(actor, replaced);
        }
        if (y != 0) {
            Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
            if (y == initialy || !BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                    consumer.queueBlockPlace(actor, finalLoc, placed.getBlockData());
                } else {
                    consumer.queueBlockReplace(actor, finalLoc.getBlock().getState(), placed.getBlockData());
                }
            }
        }
    }

    public static void smartLogFallables(Consumer consumer, Actor actor, Block origin) {
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        int up = 0;
        int highestBlock = checkBlock.getWorld().getHighestBlockYAt(checkBlock.getLocation());
        while (checkBlock.getType().hasGravity()) {
            int y;
            consumer.queueBlockBreak(actor, checkBlock.getState());
            Location loc = origin.getLocation();
            int x = loc.getBlockX();
            int z = loc.getBlockZ();
            for (y = loc.getBlockY(); y > 0 && BukkitUtils.canFallIn(loc.getWorld(), x, y - 1, z); --y) {
            }
            if (y != 0) {
                Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
                if (!BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                    finalLoc.add(0.0, (double)up, 0.0);
                    if (BukkitUtils.isEmpty(finalLoc.getBlock().getType())) {
                        consumer.queueBlockPlace(actor, finalLoc, checkBlock.getBlockData());
                    } else {
                        consumer.queueBlockReplace(actor, finalLoc, finalLoc.getBlock().getBlockData(), checkBlock.getBlockData());
                    }
                    ++up;
                }
            }
            if (checkBlock.getY() >= highestBlock) break;
            checkBlock = checkBlock.getRelative(BlockFace.UP);
        }
    }

    public static void smartLogBlockBreak(Consumer consumer, Actor actor, Block origin) {
        LoggingUtil.smartLogBlockReplace(consumer, actor, origin, null);
    }

    public static void smartLogBlockReplace(Consumer consumer, Actor actor, Block origin, BlockData replacedWith) {
        List<Location> relativeBreakables;
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        if (BukkitUtils.getRelativeTopBreakabls().contains(checkBlock.getType())) {
            if (wcfg.isLogging(Logging.SIGNTEXT) && checkBlock.getType() == Material.SIGN) {
                consumer.queueSignBreak(actor, (Sign)checkBlock.getState());
            } else if (checkBlock.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(checkBlock.getType())) {
                Block doorBlock = checkBlock;
                if (!BukkitUtils.isTop(doorBlock.getBlockData())) {
                    if ((doorBlock = doorBlock.getRelative(BlockFace.UP)).getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                        consumer.queueBlockBreak(actor, doorBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else if (BukkitUtils.isDoublePlant(checkBlock.getType())) {
                Block plantBlock = checkBlock;
                if (!BukkitUtils.isTop(plantBlock.getBlockData())) {
                    if (BukkitUtils.isDoublePlant((plantBlock = plantBlock.getRelative(BlockFace.UP)).getType())) {
                        consumer.queueBlockBreak(actor, plantBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        }
        if ((relativeBreakables = BukkitUtils.getBlocksNearby(origin, BukkitUtils.getRelativeBreakables())).size() != 0) {
            for (Location location : relativeBreakables) {
                Block block = location.getBlock();
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Directional) || !block.getRelative(((Directional)blockData).getFacing()).equals(origin)) continue;
                if (wcfg.isLogging(Logging.SIGNTEXT) && block.getType() == Material.WALL_SIGN) {
                    consumer.queueSignBreak(actor, (Sign)block.getState());
                    continue;
                }
                consumer.queueBlockBreak(actor, block.getState());
            }
        }
        if (origin.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(origin.getType())) {
            Block doorBlock = origin;
            doorBlock = !BukkitUtils.isTop(doorBlock.getBlockData()) ? doorBlock.getRelative(BlockFace.UP) : doorBlock.getRelative(BlockFace.DOWN);
            if (doorBlock.getType() == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(doorBlock.getType())) {
                consumer.queueBlockBreak(actor, doorBlock.getState());
            }
        } else if (BukkitUtils.isDoublePlant(origin.getType())) {
            Block plantBlock = origin;
            plantBlock = !BukkitUtils.isTop(origin.getBlockData()) ? plantBlock.getRelative(BlockFace.UP) : plantBlock.getRelative(BlockFace.DOWN);
            if (BukkitUtils.isDoublePlant(plantBlock.getType())) {
                consumer.queueBlockBreak(actor, plantBlock.getState());
            }
        }
        if (replacedWith == null) {
            consumer.queueBlockBreak(actor, origin.getState());
        } else {
            consumer.queueBlockReplace(actor, origin.getState(), replacedWith);
        }
    }

    public static String checkText(String text) {
        if (text == null) {
            return text;
        }
        if (Config.mb4) {
            return text;
        }
        return text.replaceAll("[^\\u0000-\\uFFFF]", "?");
    }
}

