/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.Fraction;
import de.diddiz.LogBlock.util.ItemStackAndAmount;
import de.diddiz.LogBlock.util.PaperCompatibility;
import de.diddiz.LogBlock.util.SelectableSlotContainerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DecoratedPot;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.block.data.type.Shelf;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.ShelfInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class ChestAccessLogging
extends LoggingListener {
    private static final InventoryAction PICKUP_ALL_INTO_BUNDLE;
    private static final InventoryAction PICKUP_FROM_BUNDLE;
    private static final InventoryAction PICKUP_SOME_INTO_BUNDLE;
    private static final InventoryAction PLACE_ALL_INTO_BUNDLE;
    private static final InventoryAction PLACE_FROM_BUNDLE;
    private static final InventoryAction PLACE_SOME_INTO_BUNDLE;
    private final Map<HumanEntity, PlayerActiveInventoryModifications> containersByOwner = new HashMap<HumanEntity, PlayerActiveInventoryModifications>();
    private final Map<Location, ArrayList<PlayerActiveInventoryModifications>> containersByLocation = new HashMap<Location, ArrayList<PlayerActiveInventoryModifications>>();
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT;

    public ChestAccessLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.remove(player)) != null) {
            Location loc = modifications.getLocation();
            ArrayList<PlayerActiveInventoryModifications> atLocation = this.containersByLocation.get(loc);
            atLocation.remove(modifications);
            if (atLocation.isEmpty()) {
                this.containersByLocation.remove(loc);
            }
            modifications.flush();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder;
        HumanEntity player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        if (event.getInventory() != null && ((holder = event.getInventory().getHolder()) instanceof BlockState || holder instanceof DoubleChest) && BukkitUtils.getInventoryHolderType(holder) != Material.CRAFTING_TABLE) {
            PlayerActiveInventoryModifications modifications = new PlayerActiveInventoryModifications(event.getPlayer(), BukkitUtils.getInventoryHolderLocation(holder));
            this.containersByOwner.put(modifications.getActor(), modifications);
            this.containersByLocation.compute(modifications.getLocation(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<PlayerActiveInventoryModifications>();
                }
                v.add(modifications);
                return v;
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getWhoClicked();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.get(player)) != null) {
            InventoryAction action = event.getAction();
            switch (action) {
                case PICKUP_ONE: 
                case DROP_ONE_SLOT: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -1);
                    break;
                }
                case PICKUP_HALF: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -(event.getCurrentItem().getAmount() + 1) / 2);
                    break;
                }
                case PICKUP_SOME: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    int taken = event.getCurrentItem().getAmount() - event.getCurrentItem().getMaxStackSize();
                    modifications.addModification(event.getCursor(), -taken);
                    break;
                }
                case PICKUP_ALL: 
                case DROP_ALL_SLOT: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    break;
                }
                case PLACE_ONE: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), 1);
                    break;
                }
                case PLACE_SOME: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    int placeable = event.getCurrentItem().getMaxStackSize() - event.getCurrentItem().getAmount();
                    modifications.addModification(event.getCursor(), placeable);
                    break;
                }
                case PLACE_ALL: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), event.getCursor().getAmount());
                    break;
                }
                case SWAP_WITH_CURSOR: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), event.getCursor().getAmount());
                    modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    break;
                }
                case MOVE_TO_OTHER_INVENTORY: {
                    boolean removed = event.getRawSlot() < event.getView().getTopInventory().getSize();
                    int maxMove = ChestAccessLogging.getFreeSpace(event.getCurrentItem(), removed ? event.getView().getBottomInventory() : event.getView().getTopInventory());
                    if (maxMove <= 0) break;
                    modifications.addModification(event.getCurrentItem(), Math.min(event.getCurrentItem().getAmount(), maxMove) * (removed ? -1 : 1));
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    ItemStack cursor = event.getCursor();
                    if (cursor == null) {
                        return;
                    }
                    int toPickUp = cursor.getMaxStackSize() - cursor.getAmount();
                    int takenFromContainer = 0;
                    boolean takeFromFullStacks = false;
                    Inventory top = event.getView().getTopInventory();
                    Inventory bottom = event.getView().getBottomInventory();
                    while (toPickUp > 0) {
                        int take;
                        ItemStack stack2;
                        for (ItemStack stack2 : top.getStorageContents()) {
                            if (!cursor.isSimilar(stack2) || takeFromFullStacks != (stack2.getAmount() == stack2.getMaxStackSize())) continue;
                            take = Math.min(toPickUp, stack2.getAmount());
                            takenFromContainer += take;
                            if ((toPickUp -= take) <= 0) break;
                        }
                        if (toPickUp <= 0) break;
                        ItemStack[] itemStackArray = bottom.getStorageContents();
                        int n = itemStackArray.length;
                        for (int i = 0; !(i >= n || cursor.isSimilar(stack2 = itemStackArray[i]) && takeFromFullStacks == (stack2.getAmount() == stack2.getMaxStackSize()) && (toPickUp -= (take = Math.min(toPickUp, stack2.getAmount()))) <= 0); ++i) {
                        }
                        if (takeFromFullStacks) break;
                        takeFromFullStacks = true;
                    }
                    if (takenFromContainer <= 0) break;
                    modifications.addModification(event.getCursor(), -takenFromContainer);
                    break;
                }
                case HOTBAR_SWAP: 
                case HOTBAR_MOVE_AND_READD: {
                    ItemStack otherSlot;
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    ItemStack itemStack = otherSlot = event.getClick() == ClickType.SWAP_OFFHAND ? event.getWhoClicked().getInventory().getItemInOffHand() : event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                    if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                        modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    }
                    if (otherSlot == null || otherSlot.getType() == Material.AIR) break;
                    modifications.addModification(otherSlot, otherSlot.getAmount());
                    break;
                }
                case DROP_ALL_CURSOR: 
                case DROP_ONE_CURSOR: 
                case CLONE_STACK: 
                case NOTHING: {
                    break;
                }
                default: {
                    if (action == PICKUP_ALL_INTO_BUNDLE || action == PICKUP_SOME_INTO_BUNDLE) {
                        int amount;
                        if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || event.getCursor() == null || event.getCurrentItem() == null || (amount = ChestAccessLogging.getMaxAmountToAdd(event.getCurrentItem(), event.getCursor())) <= 0) break;
                        modifications.addModification(event.getCurrentItem(), -amount);
                        break;
                    }
                    if (action == PICKUP_FROM_BUNDLE) {
                        ItemMeta meta;
                        if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || event.getCurrentItem() == null || (meta = event.getCurrentItem().getItemMeta()) == null || !(meta instanceof BundleMeta)) break;
                        BundleMeta bundleMeta = (BundleMeta)meta;
                        ItemStack newBundleStack = event.getCurrentItem().clone();
                        ArrayList bundleContent = new ArrayList(bundleMeta.getItems());
                        if (bundleContent.isEmpty()) break;
                        bundleContent.removeFirst();
                        bundleMeta = (BundleMeta)bundleMeta.clone();
                        bundleMeta.setItems(bundleContent);
                        newBundleStack.setItemMeta((ItemMeta)bundleMeta);
                        modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                        modifications.addModification(newBundleStack, newBundleStack.getAmount());
                        break;
                    }
                    if (action == PLACE_ALL_INTO_BUNDLE || action == PLACE_SOME_INTO_BUNDLE) {
                        ItemMeta meta;
                        if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || event.getCursor() == null || event.getCurrentItem() == null || (meta = event.getCurrentItem().getItemMeta()) == null || !(meta instanceof BundleMeta)) break;
                        BundleMeta bundleMeta = (BundleMeta)meta;
                        int addable = ChestAccessLogging.getMaxAmountToAdd(event.getCursor(), event.getCurrentItem());
                        if (addable <= 0) break;
                        ItemStack addToBundle = event.getCursor().clone();
                        addToBundle.setAmount(addable);
                        ItemStack newBundleStack = event.getCurrentItem().clone();
                        ArrayList<ItemStack> bundleContent = new ArrayList<ItemStack>(bundleMeta.getItems());
                        for (int i = 0; i < bundleContent.size(); ++i) {
                            if (!((ItemStack)bundleContent.get(i)).isSimilar(addToBundle)) continue;
                            addToBundle.setAmount(addToBundle.getAmount() + ((ItemStack)bundleContent.get(i)).getAmount());
                            bundleContent.remove(i);
                            break;
                        }
                        bundleContent.addFirst(addToBundle);
                        bundleMeta = (BundleMeta)bundleMeta.clone();
                        bundleMeta.setItems(bundleContent);
                        newBundleStack.setItemMeta((ItemMeta)bundleMeta);
                        modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                        modifications.addModification(newBundleStack, newBundleStack.getAmount());
                        break;
                    }
                    if (action == PLACE_FROM_BUNDLE) {
                        BundleMeta bundleMeta;
                        List items;
                        ItemMeta meta;
                        if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || event.getCursor() == null || (meta = event.getCursor().getItemMeta()) == null || !(meta instanceof BundleMeta) || (items = (bundleMeta = (BundleMeta)meta).getItems()).isEmpty()) break;
                        ItemStack item = (ItemStack)items.getFirst();
                        modifications.addModification(item, item.getAmount());
                        break;
                    }
                    this.consumer.getLogblock().getLogger().warning("Unknown inventory action by " + event.getWhoClicked().getName() + ": " + String.valueOf(event.getAction()) + " Click type: " + String.valueOf(event.getClick()) + " Slot: " + event.getSlot() + " Slot type: " + String.valueOf(event.getSlotType()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getWhoClicked();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.get(player)) != null) {
            Inventory container = event.getView().getTopInventory();
            int containerSize = container.getSize();
            for (Map.Entry e : event.getNewItems().entrySet()) {
                int slot = (Integer)e.getKey();
                if (slot >= containerSize) continue;
                ItemStack old = container.getItem(slot);
                int oldAmount = old == null || old.getType() == Material.AIR ? 0 : old.getAmount();
                modifications.addModification((ItemStack)e.getValue(), ((ItemStack)e.getValue()).getAmount() - oldAmount);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        block18: {
            BlockData blockData2;
            Material type;
            Player player;
            Block clicked;
            block19: {
                block20: {
                    ChiseledBookshelf blockData2;
                    block17: {
                        DecoratedPot pot;
                        ItemStack currentInPot;
                        BlockState blockState;
                        clicked = event.getClickedBlock();
                        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND || !event.hasBlock() || clicked == null) {
                            return;
                        }
                        player = event.getPlayer();
                        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
                            return;
                        }
                        type = clicked.getType();
                        if (type != Material.DECORATED_POT) break block17;
                        ItemStack mainHand = player.getInventory().getItemInMainHand();
                        if (mainHand != null && mainHand.getType() != Material.AIR && (blockState = clicked.getState()) instanceof DecoratedPot && ((currentInPot = (pot = (DecoratedPot)blockState).getSnapshotInventory().getItem()) == null || currentInPot.getType() == Material.AIR || currentInPot.isSimilar(mainHand) && currentInPot.getAmount() < currentInPot.getMaxStackSize())) {
                            ItemStack stack = mainHand.clone();
                            stack.setAmount(1);
                            this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), ItemStackAndAmount.fromStack(stack), false);
                        }
                        break block18;
                    }
                    if (type != Material.CHISELED_BOOKSHELF) break block19;
                    BlockData currentInPot = clicked.getBlockData();
                    if (!(currentInPot instanceof ChiseledBookshelf) || (blockData2 = (ChiseledBookshelf)currentInPot).getFacing() != event.getBlockFace() || !((currentInPot = clicked.getState()) instanceof org.bukkit.block.ChiseledBookshelf)) break block18;
                    org.bukkit.block.ChiseledBookshelf bookshelf = (org.bukkit.block.ChiseledBookshelf)currentInPot;
                    Vector pos = event.getClickedPosition();
                    if (pos == null) {
                        return;
                    }
                    int slot = SelectableSlotContainerHelper.getHitSlot(blockData2.getFacing(), pos, 2, 3);
                    ItemStack currentInSlot = bookshelf.getSnapshotInventory().getItem(slot);
                    if (!blockData2.isSlotOccupied(slot)) break block20;
                    if (currentInSlot != null && currentInSlot.getType() != Material.AIR) {
                        this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), ItemStackAndAmount.fromStack(currentInSlot), true);
                    }
                    break block18;
                }
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                if (mainHand == null || mainHand.getType() == Material.AIR || !Tag.ITEMS_BOOKSHELF_BOOKS.isTagged((Keyed)mainHand.getType())) break block18;
                ItemStack stack = mainHand.clone();
                stack.setAmount(1);
                this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), ItemStackAndAmount.fromStack(stack), false);
                break block18;
            }
            if (Tag.WOODEN_SHELVES.isTagged((Keyed)type) && (blockData2 = clicked.getBlockData()) instanceof Shelf) {
                Shelf blockData3 = (Shelf)blockData2;
                if (event.getBlockFace() == blockData3.getFacing() && (blockData2 = clicked.getState()) instanceof org.bukkit.block.Shelf) {
                    org.bukkit.block.Shelf shelf = (org.bukkit.block.Shelf)blockData2;
                    Vector pos = event.getClickedPosition();
                    if (pos == null) {
                        return;
                    }
                    int slot = SelectableSlotContainerHelper.getHitSlot(blockData3.getFacing(), pos, 1, 3);
                    ItemStack currentInSlot = shelf.getSnapshotInventory().getItem(slot);
                    if (!blockData3.isPowered()) {
                        ItemStack mainHand;
                        if (currentInSlot != null && currentInSlot.getType() != Material.AIR) {
                            this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), ItemStackAndAmount.fromStack(currentInSlot), true);
                        }
                        if ((mainHand = player.getInventory().getItemInMainHand()) != null && mainHand.getType() != Material.AIR) {
                            this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), ItemStackAndAmount.fromStack(mainHand), false);
                        }
                    } else {
                        Object sideChain;
                        Shelf neighbourData;
                        Block neighbour;
                        BlockData blockData4;
                        int i;
                        BlockFace side = BukkitUtils.rotateClockwise(blockData3.getFacing()).getOppositeFace();
                        ArrayList<Block> blockChain = new ArrayList<Block>();
                        blockChain.add(clicked);
                        for (i = 1; i < 3 && (blockData4 = (neighbour = clicked.getRelative(side, i)).getBlockData()) instanceof Shelf && (neighbourData = (Shelf)blockData4).isPowered() && neighbourData.getFacing() == blockData3.getFacing() && ((sideChain = PaperCompatibility.getShelfSideChain(neighbourData)) == PaperCompatibility.SideChain.CENTER || sideChain == PaperCompatibility.SideChain.RIGHT); ++i) {
                            blockChain.add(neighbour);
                            if (sideChain != PaperCompatibility.SideChain.CENTER) break;
                        }
                        side = side.getOppositeFace();
                        for (i = 1; i < 3 && blockChain.size() < 3 && (sideChain = (neighbour = clicked.getRelative(side, i)).getBlockData()) instanceof Shelf && (neighbourData = (Shelf)sideChain).isPowered() && neighbourData.getFacing() == blockData3.getFacing() && ((sideChain = PaperCompatibility.getShelfSideChain(neighbourData)) == PaperCompatibility.SideChain.CENTER || sideChain == PaperCompatibility.SideChain.LEFT); ++i) {
                            blockChain.add(0, neighbour);
                            if (sideChain != PaperCompatibility.SideChain.CENTER) break;
                        }
                        int chainedCount = blockChain.size();
                        int startSlot = 9 - chainedCount * 3;
                        PlayerInventory playerInventory = player.getInventory();
                        for (int i2 = 0; i2 < chainedCount; ++i2) {
                            int slotInBlock;
                            Block chainBlock = (Block)blockChain.get(i2);
                            ShelfInventory blockInventory = ((org.bukkit.block.Shelf)chainBlock.getState()).getSnapshotInventory();
                            for (slotInBlock = 0; slotInBlock < 3; ++slotInBlock) {
                                ItemStack blockItem = blockInventory.getItem(slotInBlock);
                                if (blockItem == null || blockItem.getType() == Material.AIR) continue;
                                this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), chainBlock.getLocation(), chainBlock.getBlockData(), ItemStackAndAmount.fromStack(blockItem), true);
                            }
                            for (slotInBlock = 0; slotInBlock < 3; ++slotInBlock) {
                                ItemStack playerInvItem = playerInventory.getItem(startSlot + slotInBlock + i2 * 3);
                                if (playerInvItem == null || playerInvItem.getType() == Material.AIR) continue;
                                this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), chainBlock.getLocation(), chainBlock.getBlockData(), ItemStackAndAmount.fromStack(playerInvItem), false);
                            }
                        }
                    }
                }
            }
        }
    }

    private static int getFreeSpace(ItemStack item, Inventory inventory) {
        int freeSpace = 0;
        int maxStack = Math.max(item.getMaxStackSize(), 1);
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                freeSpace += Math.max(maxStack - content.getAmount(), 0);
            } else if (content == null || content.getType() == Material.AIR) {
                freeSpace += maxStack;
            }
            if (freeSpace < item.getAmount()) continue;
            return item.getAmount();
        }
        return freeSpace;
    }

    private static Fraction computeContentWeight(List<ItemStack> content) {
        Fraction sum = Fraction.ZERO;
        for (ItemStack itemStack : content) {
            sum = sum.add(ChestAccessLogging.getWeightOfOne(itemStack).multiplyBy(Fraction.getFraction(itemStack.getAmount(), 1)));
        }
        return sum;
    }

    private static Fraction getWeightOfOne(ItemStack stack) {
        Beehive hive;
        int entityCount;
        BlockStateMeta blockStateMeta;
        BlockState blockState;
        ItemMeta meta = stack.getItemMeta();
        if (meta != null && meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            return BUNDLE_IN_BUNDLE_WEIGHT.add(ChestAccessLogging.computeContentWeight(bundleMeta.getItems()));
        }
        if (meta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof Beehive && (entityCount = (hive = (Beehive)blockState).getEntityCount()) > 0) {
            return Fraction.ONE;
        }
        return Fraction.getFraction(1, stack.getMaxStackSize());
    }

    private static int getMaxAmountToAdd(ItemStack stackToAdd, ItemStack bundle) {
        ItemMeta meta = bundle.getItemMeta();
        if (meta == null || !(meta instanceof BundleMeta)) {
            return 0;
        }
        BundleMeta bundleMeta = (BundleMeta)meta;
        Fraction weight = ChestAccessLogging.computeContentWeight(bundleMeta.getItems());
        Fraction free = Fraction.ONE.subtract(weight);
        return Math.min(stackToAdd.getAmount(), Math.max(free.divideBy(ChestAccessLogging.getWeightOfOne(stackToAdd)).intValue(), 0));
    }

    static {
        InventoryAction pickupAllIntoBundle = null;
        InventoryAction pickupFromBundle = null;
        InventoryAction pickupSomeIntoBundle = null;
        InventoryAction placeAllIntoBundle = null;
        InventoryAction placeFromBundle = null;
        InventoryAction placeSomeIntoBundle = null;
        try {
            pickupAllIntoBundle = InventoryAction.valueOf((String)"PICKUP_ALL_INTO_BUNDLE");
            pickupFromBundle = InventoryAction.valueOf((String)"PICKUP_FROM_BUNDLE");
            pickupSomeIntoBundle = InventoryAction.valueOf((String)"PICKUP_SOME_INTO_BUNDLE");
            placeAllIntoBundle = InventoryAction.valueOf((String)"PLACE_ALL_INTO_BUNDLE");
            placeFromBundle = InventoryAction.valueOf((String)"PLACE_FROM_BUNDLE");
            placeSomeIntoBundle = InventoryAction.valueOf((String)"PLACE_SOME_INTO_BUNDLE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PICKUP_ALL_INTO_BUNDLE = pickupAllIntoBundle;
        PICKUP_FROM_BUNDLE = pickupFromBundle;
        PICKUP_SOME_INTO_BUNDLE = pickupSomeIntoBundle;
        PLACE_ALL_INTO_BUNDLE = placeAllIntoBundle;
        PLACE_FROM_BUNDLE = placeFromBundle;
        PLACE_SOME_INTO_BUNDLE = placeSomeIntoBundle;
        BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction(1, 16);
    }

    private class PlayerActiveInventoryModifications {
        private final HumanEntity actor;
        private final Location location;
        private final LinkedHashMap<ItemStack, Integer> modifications;

        public PlayerActiveInventoryModifications(HumanEntity actor, Location location) {
            this.actor = actor;
            this.location = location;
            this.modifications = new LinkedHashMap();
        }

        public void addModification(ItemStack stack, int amount) {
            if (amount == 0) {
                return;
            }
            ArrayList<PlayerActiveInventoryModifications> allViewers = ChestAccessLogging.this.containersByLocation.get(this.location);
            if (allViewers.size() > 1) {
                for (PlayerActiveInventoryModifications other : allViewers) {
                    if (other == this) continue;
                    other.flush();
                }
            }
            stack = new ItemStack(stack);
            stack.setAmount(1);
            Integer existing = this.modifications.get(stack);
            int newTotal = amount + (existing == null ? 0 : existing);
            if (newTotal == 0) {
                this.modifications.remove(stack);
            } else {
                this.modifications.put(stack, newTotal);
            }
        }

        public void flush() {
            if (!this.modifications.isEmpty()) {
                for (Map.Entry<ItemStack, Integer> e : this.modifications.entrySet()) {
                    ItemStack stack = e.getKey();
                    int amount = e.getValue();
                    if (amount == 0) continue;
                    ChestAccessLogging.this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)this.actor), this.location, this.location.getWorld().getBlockAt(this.location).getBlockData(), new ItemStackAndAmount(stack, Math.abs(amount)), amount < 0);
                }
                this.modifications.clear();
            }
        }

        public HumanEntity getActor() {
            return this.actor;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

