/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class LecternLogging
extends LoggingListener {
    public LecternLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Lectern lectern;
        ItemStack currentInLectern;
        BlockState blockState;
        ItemStack mainHand;
        Block clicked = event.getClickedBlock();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND || !event.hasBlock() || clicked == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.LECTERNBOOKCHANGE)) {
            return;
        }
        Material type = clicked.getType();
        if (type == Material.LECTERN && (mainHand = player.getInventory().getItemInMainHand()) != null && mainHand.getType() != Material.AIR && Tag.ITEMS_LECTERN_BOOKS.isTagged((Keyed)mainHand.getType()) && (blockState = clicked.getState()) instanceof Lectern && ((currentInLectern = (lectern = (Lectern)blockState).getSnapshotInventory().getItem(0)) == null || currentInLectern.getType() == Material.AIR)) {
            ItemStack stack = mainHand.clone();
            stack.setAmount(1);
            Lectern newLectern = (Lectern)clicked.getState();
            newLectern.getSnapshotInventory().setItem(0, stack);
            org.bukkit.block.data.type.Lectern blockDataOld = (org.bukkit.block.data.type.Lectern)newLectern.getBlockData();
            org.bukkit.block.data.type.Lectern blockDataWithBook = (org.bukkit.block.data.type.Lectern)Bukkit.createBlockData((String)"lectern[has_book=true]");
            blockDataWithBook.setFacing(blockDataOld.getFacing());
            blockDataWithBook.setPowered(blockDataOld.isPowered());
            newLectern.setBlockData((BlockData)blockDataWithBook);
            this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), (BlockState)lectern, (BlockState)newLectern);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getPlayer().getWorld());
        if (wcfg != null && wcfg.isLogging(Logging.LECTERNBOOKCHANGE)) {
            Lectern oldState = event.getLectern();
            Lectern newState = (Lectern)oldState.getBlock().getState();
            try {
                newState.getSnapshotInventory().setItem(0, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            org.bukkit.block.data.type.Lectern oldBlockData = (org.bukkit.block.data.type.Lectern)oldState.getBlockData();
            org.bukkit.block.data.type.Lectern blockData = (org.bukkit.block.data.type.Lectern)Material.LECTERN.createBlockData();
            blockData.setFacing(oldBlockData.getFacing());
            blockData.setPowered(oldBlockData.isPowered());
            newState.setBlockData((BlockData)blockData);
            this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), (BlockState)oldState, (BlockState)newState);
        }
    }
}

