/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class EntityChangeBlockLogging
extends LoggingListener {
    public EntityChangeBlockLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Material oldType = event.getBlock().getType();
        if ((oldType == Material.REDSTONE_ORE || oldType == Material.DEEPSLATE_REDSTONE_ORE) && event.getBlockData().getMaterial() == oldType) {
            return;
        }
        if (event.getEntity() instanceof Wither) {
            if (Config.isLogging(event.getBlock().getWorld(), Logging.WITHER)) {
                this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), event.getBlock().getState(), event.getBlockData());
            }
        } else if (event.getEntity() instanceof Enderman) {
            if (Config.isLogging(event.getBlock().getWorld(), Logging.ENDERMEN)) {
                this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), event.getBlock().getState(), event.getBlockData());
            }
        } else if (event.getEntity() instanceof Sheep) {
            if (Config.isLogging(event.getBlock().getWorld(), Logging.GRASS_EAT)) {
                this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), event.getBlock().getState(), event.getBlockData());
            }
        } else if (Config.isLogging(event.getBlock().getWorld(), event.getEntity() instanceof Player ? Logging.BLOCKPLACE : Logging.MISCENTITYCHANGEBLOCK)) {
            this.consumer.queueBlockReplace(Actor.actorFromEntity(event.getEntity()), event.getBlock().getState(), event.getBlockData());
        }
    }
}

