/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DecoratedPot;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ChestAccessLogging
extends LoggingListener {
    private final Map<HumanEntity, PlayerActiveInventoryModifications> containersByOwner = new HashMap<HumanEntity, PlayerActiveInventoryModifications>();
    private final Map<Location, ArrayList<PlayerActiveInventoryModifications>> containersByLocation = new HashMap<Location, ArrayList<PlayerActiveInventoryModifications>>();

    public ChestAccessLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.remove(player)) != null) {
            Location loc = modifications.getLocation();
            ArrayList<PlayerActiveInventoryModifications> atLocation = this.containersByLocation.get(loc);
            atLocation.remove(modifications);
            if (atLocation.isEmpty()) {
                this.containersByLocation.remove(loc);
            }
            modifications.flush();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder;
        HumanEntity player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        if (event.getInventory() != null && ((holder = event.getInventory().getHolder()) instanceof BlockState || holder instanceof DoubleChest) && BukkitUtils.getInventoryHolderType(holder) != Material.CRAFTING_TABLE) {
            PlayerActiveInventoryModifications modifications = new PlayerActiveInventoryModifications(event.getPlayer(), BukkitUtils.getInventoryHolderLocation(holder));
            this.containersByOwner.put(modifications.getActor(), modifications);
            this.containersByLocation.compute(modifications.getLocation(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<PlayerActiveInventoryModifications>();
                }
                v.add(modifications);
                return v;
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getWhoClicked();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.get(player)) != null) {
            switch (event.getAction()) {
                case PICKUP_ONE: 
                case DROP_ONE_SLOT: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -1);
                    break;
                }
                case PICKUP_HALF: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -(event.getCurrentItem().getAmount() + 1) / 2);
                    break;
                }
                case PICKUP_SOME: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    int taken = event.getCurrentItem().getAmount() - event.getCurrentItem().getMaxStackSize();
                    modifications.addModification(event.getCursor(), -taken);
                    break;
                }
                case PICKUP_ALL: 
                case DROP_ALL_SLOT: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    break;
                }
                case PLACE_ONE: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), 1);
                    break;
                }
                case PLACE_SOME: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    int placeable = event.getCurrentItem().getMaxStackSize() - event.getCurrentItem().getAmount();
                    modifications.addModification(event.getCursor(), placeable);
                    break;
                }
                case PLACE_ALL: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), event.getCursor().getAmount());
                    break;
                }
                case SWAP_WITH_CURSOR: {
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    modifications.addModification(event.getCursor(), event.getCursor().getAmount());
                    modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    break;
                }
                case MOVE_TO_OTHER_INVENTORY: {
                    boolean removed = event.getRawSlot() < event.getView().getTopInventory().getSize();
                    modifications.addModification(event.getCurrentItem(), event.getCurrentItem().getAmount() * (removed ? -1 : 1));
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    ItemStack cursor = event.getCursor();
                    if (cursor == null) {
                        return;
                    }
                    int toPickUp = cursor.getMaxStackSize() - cursor.getAmount();
                    int takenFromContainer = 0;
                    boolean takeFromFullStacks = false;
                    Inventory top = event.getView().getTopInventory();
                    Inventory bottom = event.getView().getBottomInventory();
                    while (toPickUp > 0) {
                        int take;
                        ItemStack stack2;
                        for (ItemStack stack2 : top.getStorageContents()) {
                            if (!cursor.isSimilar(stack2) || takeFromFullStacks != (stack2.getAmount() == stack2.getMaxStackSize())) continue;
                            take = Math.min(toPickUp, stack2.getAmount());
                            takenFromContainer += take;
                            if ((toPickUp -= take) <= 0) break;
                        }
                        if (toPickUp <= 0) break;
                        ItemStack[] itemStackArray = bottom.getStorageContents();
                        int n = itemStackArray.length;
                        for (int i = 0; !(i >= n || cursor.isSimilar(stack2 = itemStackArray[i]) && takeFromFullStacks == (stack2.getAmount() == stack2.getMaxStackSize()) && (toPickUp -= (take = Math.min(toPickUp, stack2.getAmount()))) <= 0); ++i) {
                        }
                        if (takeFromFullStacks) break;
                        takeFromFullStacks = true;
                    }
                    if (takenFromContainer <= 0) break;
                    modifications.addModification(event.getCursor(), -takenFromContainer);
                    break;
                }
                case HOTBAR_SWAP: 
                case HOTBAR_MOVE_AND_READD: {
                    ItemStack otherSlot;
                    if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) break;
                    ItemStack itemStack = otherSlot = event.getClick() == ClickType.SWAP_OFFHAND ? event.getWhoClicked().getInventory().getItemInOffHand() : event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                    if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                        modifications.addModification(event.getCurrentItem(), -event.getCurrentItem().getAmount());
                    }
                    if (otherSlot == null || otherSlot.getType() == Material.AIR) break;
                    modifications.addModification(otherSlot, otherSlot.getAmount());
                    break;
                }
                case DROP_ALL_CURSOR: 
                case DROP_ONE_CURSOR: 
                case CLONE_STACK: 
                case NOTHING: {
                    break;
                }
                default: {
                    this.consumer.getLogblock().getLogger().warning("Unknown inventory action by " + event.getWhoClicked().getName() + ": " + String.valueOf(event.getAction()) + " Slot: " + event.getSlot() + " Slot type: " + String.valueOf(event.getSlotType()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        PlayerActiveInventoryModifications modifications;
        HumanEntity player = event.getWhoClicked();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (modifications = this.containersByOwner.get(player)) != null) {
            Inventory container = event.getView().getTopInventory();
            int containerSize = container.getSize();
            for (Map.Entry e : event.getNewItems().entrySet()) {
                int slot = (Integer)e.getKey();
                if (slot >= containerSize) continue;
                ItemStack old = container.getItem(slot);
                int oldAmount = old == null || old.getType() == Material.AIR ? 0 : old.getAmount();
                modifications.addModification((ItemStack)e.getValue(), ((ItemStack)e.getValue()).getAmount() - oldAmount);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ChiseledBookshelf blockData;
        BlockData currentInPot2;
        Block clicked = event.getClickedBlock();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND || !event.hasBlock() || clicked == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!Config.isLogging(player.getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        Material type = clicked.getType();
        if (type == Material.DECORATED_POT) {
            DecoratedPot pot;
            ItemStack currentInPot2;
            BlockState blockState;
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand != null && mainHand.getType() != Material.AIR && (blockState = clicked.getState()) instanceof DecoratedPot && ((currentInPot2 = (pot = (DecoratedPot)blockState).getSnapshotInventory().getItem()) == null || currentInPot2.getType() == Material.AIR || currentInPot2.isSimilar(mainHand) && currentInPot2.getAmount() < currentInPot2.getMaxStackSize())) {
                ItemStack stack = mainHand.clone();
                stack.setAmount(1);
                this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), stack, false);
            }
        } else if (type == Material.CHISELED_BOOKSHELF && (currentInPot2 = clicked.getBlockData()) instanceof ChiseledBookshelf && (blockData = (ChiseledBookshelf)currentInPot2).getFacing() == event.getBlockFace() && (currentInPot2 = clicked.getState()) instanceof org.bukkit.block.ChiseledBookshelf) {
            org.bukkit.block.ChiseledBookshelf bookshelf = (org.bukkit.block.ChiseledBookshelf)currentInPot2;
            Vector pos = event.getClickedPosition();
            double clickx = switch (blockData.getFacing()) {
                case BlockFace.NORTH -> 1.0 - pos.getX();
                case BlockFace.SOUTH -> pos.getX();
                case BlockFace.EAST -> 1.0 - pos.getZ();
                case BlockFace.WEST -> pos.getZ();
                default -> throw new IllegalArgumentException("Unexpected facing for chiseled bookshelf: " + String.valueOf(blockData.getFacing()));
            };
            int col = clickx < 0.375 ? 0 : (clickx < 0.6875 ? 1 : 2);
            int row = pos.getY() >= 0.5 ? 0 : 1;
            int slot = col + row * 3;
            ItemStack currentInSlot = bookshelf.getSnapshotInventory().getItem(slot);
            if (blockData.isSlotOccupied(slot)) {
                if (currentInSlot != null && currentInSlot.getType() != Material.AIR) {
                    this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), currentInSlot, true);
                }
            } else {
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                if (mainHand != null && mainHand.getType() != Material.AIR && Tag.ITEMS_BOOKSHELF_BOOKS.isTagged((Keyed)mainHand.getType())) {
                    ItemStack stack = mainHand.clone();
                    stack.setAmount(1);
                    this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), clicked.getLocation(), clicked.getBlockData(), stack, false);
                }
            }
        }
    }

    private class PlayerActiveInventoryModifications {
        private final HumanEntity actor;
        private final Location location;
        private final HashMap<ItemStack, Integer> modifications;

        public PlayerActiveInventoryModifications(HumanEntity actor, Location location) {
            this.actor = actor;
            this.location = location;
            this.modifications = new HashMap();
        }

        public void addModification(ItemStack stack, int amount) {
            if (amount == 0) {
                return;
            }
            ArrayList<PlayerActiveInventoryModifications> allViewers = ChestAccessLogging.this.containersByLocation.get(this.location);
            if (allViewers.size() > 1) {
                for (PlayerActiveInventoryModifications other : allViewers) {
                    if (other == this) continue;
                    other.flush();
                }
            }
            stack = new ItemStack(stack);
            stack.setAmount(1);
            Integer existing = this.modifications.get(stack);
            int newTotal = amount + (existing == null ? 0 : existing);
            if (newTotal == 0) {
                this.modifications.remove(stack);
            } else {
                this.modifications.put(stack, newTotal);
            }
        }

        public void flush() {
            if (!this.modifications.isEmpty()) {
                for (Map.Entry<ItemStack, Integer> e : this.modifications.entrySet()) {
                    ItemStack stack = e.getKey();
                    int amount = e.getValue();
                    stack.setAmount(Math.abs(amount));
                    ChestAccessLogging.this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)this.actor), this.location, this.location.getWorld().getBlockAt(this.location).getBlockData(), stack, amount < 0);
                }
                this.modifications.clear();
            }
        }

        public HumanEntity getActor() {
            return this.actor;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

