/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.LoggingUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BlockBreakLogging
extends LoggingListener {
    public BlockBreakLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (Config.isLogging(event.getBlock().getWorld(), Logging.BLOCKBREAK)) {
            WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
            if (wcfg == null) {
                return;
            }
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            Block origin = event.getBlock();
            Material type = origin.getType();
            if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.isContainerBlock(type) && !BukkitUtils.isShulkerBoxBlock(type)) {
                this.consumer.queueContainerBreak(actor, origin.getState());
            } else if (type == Material.ICE) {
                if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
                    LoggingUtil.smartLogBlockBreak(this.consumer, actor, origin);
                } else {
                    LoggingUtil.smartLogBlockReplace(this.consumer, actor, origin, Bukkit.createBlockData((Material)Material.WATER));
                }
            } else {
                LoggingUtil.smartLogBlockBreak(this.consumer, actor, origin);
            }
            LoggingUtil.smartLogFallables(this.consumer, actor, origin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (Config.isLogging(event.getBlockClicked().getWorld(), Logging.BLOCKBREAK)) {
            BlockData clickedBlockData = event.getBlockClicked().getBlockData();
            if (clickedBlockData instanceof Waterlogged) {
                Waterlogged clickedWaterlogged = (Waterlogged)clickedBlockData;
                if (clickedWaterlogged.isWaterlogged()) {
                    Waterlogged clickedWaterloggedWithoutWater = (Waterlogged)clickedWaterlogged.clone();
                    clickedWaterloggedWithoutWater.setWaterlogged(false);
                    this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getLocation(), (BlockData)clickedWaterlogged, (BlockData)clickedWaterloggedWithoutWater);
                }
            } else {
                this.consumer.queueBlockBreak(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getState());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDropItem(BlockDropItemEvent event) {
        Material type;
        if (Config.isLogging(event.getBlock().getWorld(), Logging.BLOCKBREAK) && ((type = event.getBlock().getType()) == Material.SUSPICIOUS_GRAVEL || type == Material.SUSPICIOUS_SAND)) {
            Material simplyBroken;
            Material material = simplyBroken = type == Material.SUSPICIOUS_SAND ? Material.SAND : Material.GRAVEL;
            if (event.getItems().size() != 1 || ((Item)event.getItems().get(0)).getItemStack().getType() != simplyBroken) {
                this.consumer.queueBlockReplace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockState(), simplyBroken.createBlockData());
            }
        }
    }
}

