/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.LoggingUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;

public class BlockPlaceLogging
extends LoggingListener {
    public BlockPlaceLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (Config.isLogging(event.getBlock().getWorld(), Logging.BLOCKPLACE)) {
            BlockState before = event.getBlockReplacedState();
            BlockState after = event.getBlockPlaced().getState();
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            LoggingUtil.smartLogBlockPlace(this.consumer, actor, before, after);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (Config.isLogging(event.getPlayer().getWorld(), Logging.BLOCKPLACE)) {
            this.consumer.queueBlockPlace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getRelative(event.getBlockFace()).getLocation(), Bukkit.createBlockData((Material)(event.getBucket() == Material.WATER_BUCKET ? Material.WATER : Material.LAVA)));
        }
    }
}

