/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlockStateCodecSign
implements BlockStateCodec {
    @Override
    public Material[] getApplicableMaterials() {
        return BukkitUtils.getAllSignMaterials().toArray(new Material[BukkitUtils.getAllSignMaterials().size()]);
    }

    @Override
    public YamlConfiguration serialize(BlockState state) {
        if (state instanceof Sign) {
            DyeColor signColor;
            Sign sign = (Sign)state;
            String[] lines = sign.getLines();
            boolean hasText = false;
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null || lines[i].length() <= 0) continue;
                hasText = true;
                break;
            }
            if ((signColor = sign.getColor()) == null) {
                signColor = DyeColor.BLACK;
            }
            if (hasText || signColor != DyeColor.BLACK) {
                YamlConfiguration conf = new YamlConfiguration();
                if (hasText) {
                    conf.set("lines", Arrays.asList(lines));
                }
                if (signColor != DyeColor.BLACK) {
                    conf.set("color", (Object)signColor.name());
                }
                if (sign.isGlowingText()) {
                    conf.set("glowing", (Object)true);
                }
                return conf;
            }
        }
        return null;
    }

    public static YamlConfiguration serialize(String[] lines) {
        YamlConfiguration conf = new YamlConfiguration();
        if (lines != null) {
            conf.set("lines", Arrays.asList(lines));
        }
        return conf;
    }

    @Override
    public void deserialize(BlockState state, YamlConfiguration conf) {
        if (state instanceof Sign) {
            Sign sign = (Sign)state;
            DyeColor signColor = DyeColor.BLACK;
            boolean glowing = false;
            List lines = Collections.emptyList();
            if (conf != null) {
                if (conf.contains("lines")) {
                    lines = conf.getStringList("lines");
                }
                if (conf.contains("color")) {
                    try {
                        signColor = DyeColor.valueOf((String)conf.getString("color"));
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
                glowing = conf.getBoolean("glowing", false);
            }
            for (int i = 0; i < 4; ++i) {
                String line = lines.size() > i && lines.get(i) != null ? (String)lines.get(i) : "";
                sign.setLine(i, line);
            }
            sign.setColor(signColor);
            sign.setGlowingText(glowing);
        }
    }

    @Override
    public String toString(YamlConfiguration state, YamlConfiguration oldState) {
        if (state != null) {
            List lines = state.getStringList("lines");
            List oldLines = Collections.emptyList();
            DyeColor signColor = DyeColor.BLACK;
            if (state.contains("color")) {
                try {
                    signColor = DyeColor.valueOf((String)state.getString("color"));
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
            DyeColor oldSignColor = DyeColor.BLACK;
            boolean glowing = state.getBoolean("glowing", false);
            boolean oldGlowing = false;
            if (oldState != null) {
                oldLines = oldState.getStringList("lines");
                if (oldState.contains("color")) {
                    try {
                        oldSignColor = DyeColor.valueOf((String)oldState.getString("color"));
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
                oldGlowing = oldState.getBoolean("glowing", false);
            }
            StringBuilder sb = new StringBuilder();
            if (!lines.equals(oldLines)) {
                for (String line : lines) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append("[").append(line).append("]");
                }
            }
            if (signColor != oldSignColor) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("(color: " + signColor.name().toLowerCase() + ")");
            }
            if (glowing != oldGlowing) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (glowing) {
                    sb.append("(glowing)");
                } else {
                    sb.append("(not glowing)");
                }
            }
            return sb.toString();
        }
        return null;
    }
}

