/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlockStateCodecSkull
implements BlockStateCodec {
    @Override
    public Material[] getApplicableMaterials() {
        return new Material[]{Material.PLAYER_WALL_HEAD, Material.PLAYER_HEAD};
    }

    @Override
    public YamlConfiguration serialize(BlockState state) {
        if (state instanceof Skull) {
            OfflinePlayer owner;
            Skull skull = (Skull)state;
            OfflinePlayer offlinePlayer = owner = skull.hasOwner() ? skull.getOwningPlayer() : null;
            if (owner != null) {
                YamlConfiguration conf = new YamlConfiguration();
                conf.set("owner", (Object)owner.getUniqueId().toString());
                return conf;
            }
        }
        return null;
    }

    @Override
    public void deserialize(BlockState state, YamlConfiguration conf) {
        if (state instanceof Skull) {
            UUID ownerId;
            Skull skull = (Skull)state;
            UUID uUID = ownerId = conf == null ? null : UUID.fromString(conf.getString("owner"));
            if (ownerId == null) {
                skull.setOwningPlayer(null);
            } else {
                skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)ownerId));
            }
        }
    }

    @Override
    public String toString(YamlConfiguration conf, YamlConfiguration oldState) {
        UUID ownerId;
        UUID uUID = ownerId = conf == null ? null : UUID.fromString(conf.getString("owner"));
        if (ownerId != null) {
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerId);
            return "[" + (owner.getName() != null ? owner.getName() : owner.getUniqueId().toString()) + "]";
        }
        return null;
    }
}

