/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.EntityChange;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.Utils;
import de.diddiz.LogBlock.worldedit.WorldEditHelper;
import java.io.File;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldEditor
implements Runnable {
    private final LogBlock logblock;
    private final ArrayList<Edit> edits = new ArrayList();
    private final World world;
    private CommandSender sender;
    private int taskID;
    private int successes = 0;
    private int blacklistCollisions = 0;
    private long elapsedTime = 0L;
    public LookupCacheElement[] errors;
    private boolean forceReplace;
    private HashMap<Integer, UUID> uuidReplacements = new HashMap();
    private boolean started = false;

    public WorldEditor(LogBlock logblock, World world) {
        this(logblock, world, false);
    }

    public WorldEditor(LogBlock logblock, World world, boolean forceReplace) {
        this.logblock = logblock;
        this.world = world;
        this.forceReplace = forceReplace;
    }

    public int getSize() {
        return this.edits.size();
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getErrors() {
        return this.errors.length;
    }

    public int getBlacklistCollisions() {
        return this.blacklistCollisions;
    }

    public void setSender(CommandSender sender) {
        this.sender = sender;
    }

    public void queueBlockEdit(long time, int x, int y, int z, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess item) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.edits.add(new BlockEdit(time, new Location(this.world, (double)x, (double)y, (double)z), null, replaced, replaceData, replacedState, type, typeData, typeState, item));
    }

    public void queueEntityEdit(ResultSet rs, QueryParams p, boolean rollback) throws SQLException {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.edits.add(new EntityEdit(rs, p, rollback));
    }

    public void reverseRowOrder() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        Collections.reverse(this.edits);
    }

    public void sortRows(QueryParams.Order order) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.edits.sort(new EditComparator(order));
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        long start = System.currentTimeMillis();
        this.taskID = this.logblock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.logblock, (Runnable)this, 0L, 1L);
        if (this.taskID == -1) {
            throw new Exception("Failed to schedule task");
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            throw new Exception("Interrupted");
        }
        this.elapsedTime = System.currentTimeMillis() - start;
    }

    @Override
    public synchronized void run() {
        ArrayList<WorldEditorException> errorList = new ArrayList<WorldEditorException>();
        float size = this.edits.size();
        for (int counter = 0; !this.edits.isEmpty() && counter < 100; ++counter) {
            float percentage;
            try {
                switch (this.edits.remove(this.edits.size() - 1).perform()) {
                    case SUCCESS: {
                        ++this.successes;
                        break;
                    }
                    case BLACKLISTED: {
                        ++this.blacklistCollisions;
                        break;
                    }
                }
                continue;
            }
            catch (WorldEditorException ex) {
                errorList.add(ex);
                continue;
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.WARNING, "[WorldEditor] Exeption: ", ex);
            }
            if (this.sender == null || (percentage = (size - (float)this.edits.size()) / size * 100.0f) % 20.0f != 0.0f) continue;
            this.sender.sendMessage(ChatColor.GOLD + "[LogBlock]" + ChatColor.YELLOW + " Rollback progress: " + percentage + "% Blocks edited: " + counter);
        }
        if (this.edits.isEmpty()) {
            this.logblock.getServer().getScheduler().cancelTask(this.taskID);
            if (errorList.size() > 0) {
                try {
                    File file = new File("plugins/LogBlock/error/WorldEditor-" + new SimpleDateFormat("yy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + ".log");
                    file.getParentFile().mkdirs();
                    PrintWriter writer = new PrintWriter(file);
                    for (LookupCacheElement lookupCacheElement : errorList) {
                        writer.println(BaseComponent.toPlainText((BaseComponent[])lookupCacheElement.getLogMessage()));
                    }
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.errors = errorList.toArray(new WorldEditorException[errorList.size()]);
            this.notify();
        }
    }

    protected UUID getReplacedUUID(int entityid, UUID unreplaced) {
        UUID replaced = this.uuidReplacements.get(entityid);
        return replaced != null ? replaced : unreplaced;
    }

    public class BlockEdit
    extends BlockChange
    implements Edit {
        public BlockEdit(long time, Location loc, Actor actor, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
            super(time, loc, actor, replaced, replaceData, replacedState, type, typeData, typeState, ca);
        }

        @Override
        public long getTime() {
            return this.date;
        }

        @Override
        public PerformResult perform() throws WorldEditorException {
            Chest chest;
            BlockData replacedBlock = this.getBlockReplaced();
            BlockData setBlock = this.getBlockSet();
            if (replacedBlock == null || setBlock == null) {
                throw new WorldEditorException("Could not parse the material", this.loc.clone());
            }
            if (Config.dontRollback.contains(replacedBlock.getMaterial())) {
                return PerformResult.BLACKLISTED;
            }
            Block block = this.loc.getBlock();
            if (BukkitUtils.isEmpty(replacedBlock.getMaterial()) && BukkitUtils.isEmpty(block.getType())) {
                return PerformResult.NO_ACTION;
            }
            BlockState state = block.getState();
            if (setBlock.equals(replacedBlock) && this.ca != null) {
                if (state instanceof Container && state.getType() == replacedBlock.getMaterial()) {
                    int leftover;
                    try {
                        leftover = BukkitUtils.modifyContainer(state, new ItemStack(this.ca.itemStack), !this.ca.remove);
                    }
                    catch (Exception ex) {
                        throw new WorldEditorException(ex.getMessage(), block.getLocation());
                    }
                    if (leftover > 0 && this.ca.remove) {
                        throw new WorldEditorException("Not enough space left in " + block.getType(), block.getLocation());
                    }
                    return PerformResult.SUCCESS;
                }
                return PerformResult.NO_ACTION;
            }
            if (!(WorldEditor.this.forceReplace || BukkitUtils.isSimilarForRollback(setBlock.getMaterial(), block.getType()) || block.isEmpty() || Config.replaceAnyway.contains(block.getType()))) {
                return PerformResult.NO_ACTION;
            }
            if (state instanceof Container && replacedBlock.getMaterial() != block.getType()) {
                ((Container)state).getSnapshotInventory().clear();
                state.update();
            }
            block.setBlockData(replacedBlock);
            BlockData newData = block.getBlockData();
            if (BlockStateCodecs.hasCodec(replacedBlock.getMaterial())) {
                state = block.getState();
                try {
                    BlockStateCodecs.deserialize(state, Utils.deserializeYamlConfiguration(this.replacedState));
                    state.update();
                }
                catch (Exception e) {
                    throw new WorldEditorException("Failed to restore blockstate of " + block.getType() + ": " + e, block.getLocation());
                }
            }
            Material curtype = block.getType();
            if (newData instanceof Bed) {
                Block secBlock;
                Bed bed = (Bed)newData;
                Block block2 = secBlock = bed.getPart() == Bed.Part.HEAD ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                if (secBlock.isEmpty()) {
                    Bed bed2 = (Bed)bed.clone();
                    bed2.setPart(bed.getPart() == Bed.Part.HEAD ? Bed.Part.FOOT : Bed.Part.HEAD);
                    secBlock.setBlockData((BlockData)bed2);
                }
            } else if (curtype == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(curtype) || BukkitUtils.isDoublePlant(curtype)) {
                Bisected firstPart = (Bisected)newData;
                Block secBlock = block.getRelative(firstPart.getHalf() == Bisected.Half.TOP ? BlockFace.DOWN : BlockFace.UP);
                if (secBlock.isEmpty()) {
                    Bisected secondPart = (Bisected)firstPart.clone();
                    secondPart.setHalf(firstPart.getHalf() == Bisected.Half.TOP ? Bisected.Half.BOTTOM : Bisected.Half.TOP);
                    secBlock.setBlockData((BlockData)secondPart);
                }
            } else if (curtype == Material.PISTON || curtype == Material.STICKY_PISTON) {
                Block secBlock;
                Piston piston = (Piston)newData;
                if (piston.isExtended() && (secBlock = block.getRelative(piston.getFacing())).isEmpty()) {
                    PistonHead head = (PistonHead)Material.PISTON_HEAD.createBlockData();
                    head.setFacing(piston.getFacing());
                    head.setType(curtype == Material.PISTON ? TechnicalPiston.Type.NORMAL : TechnicalPiston.Type.STICKY);
                    secBlock.setBlockData((BlockData)head);
                }
            } else if (curtype == Material.PISTON_HEAD) {
                PistonHead head = (PistonHead)newData;
                Block secBlock = block.getRelative(head.getFacing().getOppositeFace());
                if (secBlock.isEmpty()) {
                    Piston piston = (Piston)(head.getType() == TechnicalPiston.Type.NORMAL ? Material.PISTON : Material.STICKY_PISTON).createBlockData();
                    piston.setFacing(head.getFacing());
                    piston.setExtended(true);
                    secBlock.setBlockData((BlockData)piston);
                }
            } else if (newData instanceof Chest && (chest = (Chest)newData).getType() != Chest.Type.SINGLE && BukkitUtils.getConnectedChest(block) == null) {
                chest.setType(Chest.Type.SINGLE);
                block.setBlockData((BlockData)chest);
            }
            return PerformResult.SUCCESS;
        }
    }

    public class EntityEdit
    extends EntityChange
    implements Edit {
        private boolean rollback;

        public EntityEdit(ResultSet rs, QueryParams p, boolean rollback) throws SQLException {
            super(rs, p);
            this.rollback = rollback;
        }

        @Override
        public long getTime() {
            return this.date;
        }

        @Override
        public PerformResult perform() throws WorldEditorException {
            if (this.type == null) {
                throw new WorldEditorException("Unkown entity type for entity " + this.entityUUID, this.loc);
            }
            if (this.changeType == (this.rollback ? EntityChange.EntityChangeType.KILL : EntityChange.EntityChangeType.CREATE)) {
                UUID uuid = WorldEditor.this.getReplacedUUID(this.entityId, this.entityUUID);
                Entity result = null;
                YamlConfiguration deserialized = Utils.deserializeYamlConfiguration(this.data);
                double x = deserialized.getDouble("x");
                double y = deserialized.getDouble("y");
                double z = deserialized.getDouble("z");
                float yaw = (float)deserialized.getDouble("yaw");
                float pitch = (float)deserialized.getDouble("pitch");
                Location location = new Location(WorldEditor.this.world, x, y, z, yaw, pitch);
                Entity existing = BukkitUtils.loadEntityAround(location.getChunk(), uuid);
                if (existing != null) {
                    return PerformResult.NO_ACTION;
                }
                byte[] serializedWorldEditEntity = (byte[])deserialized.get("worldedit");
                if (serializedWorldEditEntity != null) {
                    result = WorldEditHelper.restoreEntity(location, this.type, serializedWorldEditEntity);
                }
                if (result == null) {
                    throw new WorldEditorException("Could not restore " + this.type, location);
                }
                if (!result.getUniqueId().equals(uuid)) {
                    WorldEditor.this.logblock.getConsumer().queueEntityUUIDChange(WorldEditor.this.world, this.entityId, result.getUniqueId());
                    WorldEditor.this.uuidReplacements.put(this.entityId, result.getUniqueId());
                }
                return PerformResult.SUCCESS;
            }
            if (this.changeType == (this.rollback ? EntityChange.EntityChangeType.CREATE : EntityChange.EntityChangeType.KILL)) {
                UUID uuid = WorldEditor.this.getReplacedUUID(this.entityId, this.entityUUID);
                YamlConfiguration deserialized = Utils.deserializeYamlConfiguration(this.data);
                double x = deserialized.getDouble("x");
                double y = deserialized.getDouble("y");
                double z = deserialized.getDouble("z");
                float yaw = (float)deserialized.getDouble("yaw");
                float pitch = (float)deserialized.getDouble("pitch");
                Location location = new Location(WorldEditor.this.world, x, y, z, yaw, pitch);
                Entity existing = BukkitUtils.loadEntityAround(location.getChunk(), uuid);
                if (existing != null) {
                    existing.remove();
                    return PerformResult.SUCCESS;
                }
                return PerformResult.NO_ACTION;
            }
            if (this.changeType == (this.rollback ? EntityChange.EntityChangeType.REMOVEEQUIP : EntityChange.EntityChangeType.ADDEQUIP)) {
                UUID uuid = WorldEditor.this.getReplacedUUID(this.entityId, this.entityUUID);
                Entity existing = BukkitUtils.loadEntityAround(this.loc.getChunk(), uuid);
                if (existing != null) {
                    EquipmentSlot slot;
                    ArmorStand stand;
                    ItemStack old;
                    YamlConfiguration deserialized = Utils.deserializeYamlConfiguration(this.data);
                    ItemStack item = deserialized.getItemStack("item");
                    if (item != null && existing instanceof ItemFrame) {
                        ItemStack old2 = ((ItemFrame)existing).getItem();
                        if (old2 == null || old2.getType() == Material.AIR) {
                            ((ItemFrame)existing).setItem(item);
                            return PerformResult.SUCCESS;
                        }
                    } else if (item != null && existing instanceof ArmorStand && ((old = BukkitUtils.getItemInSlot(stand = (ArmorStand)existing, slot = EquipmentSlot.valueOf((String)deserialized.getString("slot")))) == null || old.getType() == Material.AIR)) {
                        BukkitUtils.setItemInSlot(stand, slot, item);
                        return PerformResult.SUCCESS;
                    }
                }
                return PerformResult.NO_ACTION;
            }
            if (this.changeType == (this.rollback ? EntityChange.EntityChangeType.ADDEQUIP : EntityChange.EntityChangeType.REMOVEEQUIP)) {
                UUID uuid = WorldEditor.this.getReplacedUUID(this.entityId, this.entityUUID);
                Entity existing = BukkitUtils.loadEntityAround(this.loc.getChunk(), uuid);
                if (existing != null) {
                    EquipmentSlot slot;
                    ArmorStand stand;
                    ItemStack old;
                    YamlConfiguration deserialized = Utils.deserializeYamlConfiguration(this.data);
                    ItemStack item = deserialized.getItemStack("item");
                    if (item != null && existing instanceof ItemFrame) {
                        ItemStack old3 = ((ItemFrame)existing).getItem();
                        if (old3 != null && old3.isSimilar(item)) {
                            ((ItemFrame)existing).setItem(null);
                            return PerformResult.SUCCESS;
                        }
                    } else if (item != null && existing instanceof ArmorStand && (old = BukkitUtils.getItemInSlot(stand = (ArmorStand)existing, slot = EquipmentSlot.valueOf((String)deserialized.getString("slot")))) != null && old.isSimilar(item)) {
                        BukkitUtils.setItemInSlot(stand, slot, null);
                        return PerformResult.SUCCESS;
                    }
                }
                return PerformResult.NO_ACTION;
            }
            if (this.changeType == EntityChange.EntityChangeType.GET_STUNG) {
                UUID uuid = WorldEditor.this.getReplacedUUID(this.entityId, this.entityUUID);
                Entity existing = BukkitUtils.loadEntityAround(this.loc.getChunk(), uuid);
                if (existing != null && existing instanceof Bee) {
                    ((Bee)existing).setHasStung(!this.rollback);
                }
            }
            return PerformResult.NO_ACTION;
        }
    }

    public static class EditComparator
    implements Comparator<Edit> {
        private final int mult;

        public EditComparator(QueryParams.Order order) {
            this.mult = order == QueryParams.Order.DESC ? 1 : -1;
        }

        @Override
        public int compare(Edit edit1, Edit edit2) {
            long time2;
            long time1 = edit1.getTime();
            return time1 > (time2 = edit2.getTime()) ? this.mult : (time1 < time2 ? -this.mult : 0);
        }
    }

    public static interface Edit {
        public PerformResult perform() throws WorldEditorException;

        public long getTime();
    }

    public static enum PerformResult {
        SUCCESS,
        BLACKLISTED,
        NO_ACTION;

    }

    public static class WorldEditorException
    extends Exception
    implements LookupCacheElement {
        private final Location loc;

        public WorldEditorException(Material typeBefore, Material typeAfter, Location loc) {
            this("Failed to replace " + typeBefore.name() + " with " + typeAfter.name(), loc);
        }

        public WorldEditorException(String msg, Location loc) {
            super(msg + " at " + loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ());
            this.loc = loc;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }

        @Override
        public BaseComponent[] getLogMessage(int entry) {
            return TextComponent.fromLegacyText((String)this.getMessage());
        }
    }
}

