/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityInteractEvent;

public class CreatureInteractLogging
extends LoggingListener {
    public CreatureInteractLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getEntity().getWorld());
        EntityType entityType = event.getEntityType();
        if (event.getEntity() instanceof Player || entityType == null) {
            return;
        }
        if (wcfg != null) {
            Block clicked = event.getBlock();
            Material type = clicked.getType();
            Location loc = clicked.getLocation();
            if (type == Material.FARMLAND && wcfg.isLogging(Logging.CREATURECROPTRAMPLE)) {
                this.consumer.queueBlock(Actor.actorFromEntity(entityType), loc, type.createBlockData(), Material.DIRT.createBlockData());
                Block trampledCrop = clicked.getRelative(BlockFace.UP);
                if (BukkitUtils.getCropBlocks().contains(trampledCrop.getType())) {
                    this.consumer.queueBlockBreak(new Actor("CreatureTrample"), trampledCrop.getState());
                }
            }
        }
    }
}

