/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.LoggingUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BlockBreakLogging
extends LoggingListener {
    public BlockBreakLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (Config.isLogging(event.getBlock().getWorld(), Logging.BLOCKBREAK)) {
            WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
            if (wcfg == null) {
                return;
            }
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            Block origin = event.getBlock();
            Material type = origin.getType();
            if (wcfg.isLogging(Logging.SIGNTEXT) && (type == Material.SIGN || type == Material.WALL_SIGN)) {
                this.consumer.queueSignBreak(actor, (Sign)origin.getState());
            } else if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.getContainerBlocks().contains(type)) {
                this.consumer.queueContainerBreak(actor, origin.getState());
            } else if (type == Material.ICE) {
                if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
                    this.consumer.queueBlockBreak(actor, origin.getState());
                } else {
                    this.consumer.queueBlockReplace(actor, origin.getState(), Bukkit.createBlockData((Material)Material.WATER));
                }
            } else {
                LoggingUtil.smartLogBlockBreak(this.consumer, actor, origin);
            }
            LoggingUtil.smartLogFallables(this.consumer, actor, origin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (Config.isLogging(event.getBlockClicked().getWorld(), Logging.BLOCKBREAK)) {
            this.consumer.queueBlockBreak(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getState());
        }
    }
}

