/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class DumpedLogImporter
implements Runnable {
    private final LogBlock logblock;

    DumpedLogImporter(LogBlock logblock) {
        this.logblock = logblock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File[] imports = new File("plugins/LogBlock/import/").listFiles(new Utils.ExtensionFilenameFilter("sql"));
        if (imports != null && imports.length > 0) {
            this.logblock.getLogger().info("Found " + imports.length + " imports.");
            Connection conn = null;
            try {
                conn = this.logblock.getConnection();
                if (conn == null) {
                    return;
                }
                conn.setAutoCommit(false);
                Statement st = conn.createStatement();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.logblock.getDataFolder(), "import/failed.txt")));
                int successes = 0;
                int errors = 0;
                try {
                    for (File sqlFile : imports) {
                        String line = null;
                        try {
                            this.logblock.getLogger().info("Trying to import " + sqlFile.getName() + " ...");
                            BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                            while ((line = reader.readLine()) != null) {
                                if (line.endsWith(";")) {
                                    line = line.substring(0, line.length() - 1);
                                }
                                if (line.isEmpty()) continue;
                                st.addBatch(line);
                                ++successes;
                            }
                            st.executeBatch();
                            conn.commit();
                            reader.close();
                            sqlFile.delete();
                            this.logblock.getLogger().info("Successfully imported " + sqlFile.getName() + ".");
                        }
                        catch (Exception ex) {
                            this.logblock.getLogger().warning("Error while importing: '" + line + "': " + ex.getMessage());
                            writer.write(line + Utils.newline);
                            ++errors;
                            ex.printStackTrace();
                            writer.close();
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
                finally {
                    writer.close();
                }
                st.close();
                this.logblock.getLogger().info("Successfully imported stored queue. (" + successes + " rows imported, " + errors + " errors)");
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.WARNING, "Error while importing: ", ex);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

