/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;

public class FluidFlowLogging
extends LoggingListener {
    public FluidFlowLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        block20: {
            Material typeTo;
            Block to;
            Block source;
            boolean fromWaterlogged;
            Material typeFrom;
            BlockData blockDataFrom;
            WorldConfig wcfg;
            block21: {
                block22: {
                    boolean canFlow;
                    wcfg = Config.getWorldConfig(event.getBlock().getWorld());
                    if (wcfg == null || !wcfg.isLogging(Logging.WATERFLOW) && !wcfg.isLogging(Logging.LAVAFLOW)) break block20;
                    blockDataFrom = event.getBlock().getBlockData();
                    typeFrom = blockDataFrom.getMaterial();
                    fromWaterlogged = false;
                    if (blockDataFrom instanceof Waterlogged) {
                        typeFrom = Material.WATER;
                        fromWaterlogged = true;
                    }
                    if (typeFrom == Material.SEAGRASS || typeFrom == Material.KELP_PLANT || typeFrom == Material.KELP) {
                        typeFrom = Material.WATER;
                        fromWaterlogged = true;
                    }
                    source = Config.logFluidFlowAsPlayerWhoTriggeredIt ? event.getBlock() : null;
                    to = event.getToBlock();
                    typeTo = to.getType();
                    boolean bl = canFlow = BukkitUtils.isEmpty(typeTo) || BukkitUtils.getNonFluidProofBlocks().contains(typeTo);
                    if (typeFrom != Material.LAVA || !wcfg.isLogging(Logging.LAVAFLOW)) break block21;
                    Levelled levelledFrom = (Levelled)blockDataFrom;
                    if (!canFlow) break block22;
                    if (FluidFlowLogging.isSurroundedByWater(to) && levelledFrom.getLevel() <= 2) {
                        this.consumer.queueBlockReplace(new Actor("LavaFlow", source), to.getState(), Material.COBBLESTONE.createBlockData());
                    } else {
                        Levelled newBlock = (Levelled)blockDataFrom.clone();
                        newBlock.setLevel(levelledFrom.getLevel() + 1);
                        if (BukkitUtils.isEmpty(typeTo)) {
                            this.consumer.queueBlockPlace(new Actor("LavaFlow", source), to.getLocation(), (BlockData)newBlock);
                        } else {
                            this.consumer.queueBlockReplace(new Actor("LavaFlow", source), to.getState(), (BlockData)newBlock);
                        }
                    }
                    break block20;
                }
                if (typeTo != Material.WATER) break block20;
                if (event.getFace() == BlockFace.DOWN) {
                    this.consumer.queueBlockReplace(new Actor("LavaFlow", source), to.getState(), Material.STONE.createBlockData());
                } else {
                    this.consumer.queueBlockReplace(new Actor("LavaFlow", source), to.getState(), Material.COBBLESTONE.createBlockData());
                }
                break block20;
            }
            if (typeFrom == Material.WATER && wcfg.isLogging(Logging.WATERFLOW)) {
                Levelled levelledFrom = fromWaterlogged ? null : (Levelled)blockDataFrom;
                Levelled newBlock = (Levelled)Material.WATER.createBlockData();
                newBlock.setLevel(fromWaterlogged ? 1 : levelledFrom.getLevel() + 1);
                if (BukkitUtils.isEmpty(typeTo)) {
                    this.consumer.queueBlockPlace(new Actor("WaterFlow", source), to.getLocation(), (BlockData)newBlock);
                } else if (BukkitUtils.getNonFluidProofBlocks().contains(typeTo)) {
                    this.consumer.queueBlockReplace(new Actor("WaterFlow", source), to.getState(), (BlockData)newBlock);
                } else if (typeTo == Material.LAVA) {
                    int toLevel = ((Levelled)to.getBlockData()).getLevel();
                    if (toLevel == 0) {
                        this.consumer.queueBlockReplace(new Actor("WaterFlow", source), to.getState(), Material.OBSIDIAN.createBlockData());
                    } else if (event.getFace() == BlockFace.DOWN) {
                        this.consumer.queueBlockReplace(new Actor("WaterFlow", source), to.getState(), Material.STONE.createBlockData());
                    }
                }
                if (BukkitUtils.isEmpty(typeTo) || BukkitUtils.getNonFluidProofBlocks().contains(typeTo)) {
                    for (BlockFace face : new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
                        Block lower = to.getRelative(face);
                        if (lower.getType() != Material.LAVA) continue;
                        int toLevel = ((Levelled)lower.getBlockData()).getLevel();
                        if (toLevel == 0) {
                            this.consumer.queueBlockReplace(new Actor("WaterFlow", source), lower.getState(), Material.OBSIDIAN.createBlockData());
                            continue;
                        }
                        if (event.getFace() != BlockFace.DOWN) continue;
                        this.consumer.queueBlockReplace(new Actor("WaterFlow", source), lower.getState(), Material.STONE.createBlockData());
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
        if (wcfg != null && (wcfg.isLogging(Logging.WATERFLOW) || wcfg.isLogging(Logging.LAVAFLOW))) {
            if (wcfg.isLogging(Logging.LAVAFLOW) && event.getBlock().getType() == Material.WATER && event.getNewState().getType() == Material.COBBLESTONE) {
                this.consumer.queueBlockReplace(new Actor("LavaFlow"), event.getBlock().getBlockData(), event.getNewState());
            }
            if (wcfg.isLogging(Logging.WATERFLOW) && event.getBlock().getType() == Material.LAVA) {
                this.consumer.queueBlockReplace(new Actor("WaterFlow"), event.getBlock().getBlockData(), event.getNewState());
            }
            if (wcfg.isLogging(Logging.WATERFLOW) && BukkitUtils.isConcreteBlock(event.getNewState().getType())) {
                this.consumer.queueBlockReplace(new Actor("WaterFlow"), event.getBlock().getBlockData(), event.getNewState());
            }
        }
    }

    private static boolean isSurroundedByWater(Block block) {
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
            if (block.getRelative(face).getType() != Material.WATER) continue;
            return true;
        }
        return false;
    }
}

