/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class KillLogging
extends LoggingListener {
    public KillLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent deathEvent) {
        EntityDamageEvent event = deathEvent.getEntity().getLastDamageCause();
        if (event != null && !event.isCancelled() && Config.isLogging(event.getEntity().getWorld(), Logging.KILL) && event.getEntity() instanceof LivingEntity) {
            LivingEntity victim = (LivingEntity)event.getEntity();
            if (event instanceof EntityDamageByEntityEvent) {
                Entity killer = ((EntityDamageByEntityEvent)event).getDamager();
                if (!(Config.logKillsLevel != Config.LogKillsLevel.PLAYERS || victim instanceof Player && killer instanceof Player)) {
                    return;
                }
                if (!(Config.logKillsLevel != Config.LogKillsLevel.MONSTERS || (victim instanceof Player || victim instanceof Monster) && killer instanceof Player || killer instanceof Monster)) {
                    return;
                }
                this.consumer.queueKill(killer, (Entity)victim);
            } else if (Config.logEnvironmentalKills) {
                if (Config.logKillsLevel == Config.LogKillsLevel.PLAYERS && !(victim instanceof Player)) {
                    return;
                }
                if (Config.logKillsLevel == Config.LogKillsLevel.MONSTERS && !(victim instanceof Player) && !(victim instanceof Monster)) {
                    return;
                }
                this.consumer.queueKill(new Actor(event.getCause().toString()), (Entity)victim);
            }
        }
    }
}

