/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.config.Config;
import de.diddiz.lib.com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQLConnectionPool
implements Closeable {
    private final HikariDataSource ds = new HikariDataSource();

    public MySQLConnectionPool(String url, String user, String password) {
        this.ds.setJdbcUrl(url);
        this.ds.setUsername(user);
        this.ds.setPassword(password);
        this.ds.setMinimumIdle(2);
        this.ds.setMaximumPoolSize(15);
        this.ds.setPoolName("LogBlock-Connection-Pool");
        this.ds.addDataSourceProperty("useUnicode", "true");
        this.ds.addDataSourceProperty("characterEncoding", "utf-8");
        this.ds.addDataSourceProperty("rewriteBatchedStatements", "true");
        this.ds.addDataSourceProperty("cachePrepStmts", "true");
        this.ds.addDataSourceProperty("prepStmtCacheSize", "250");
        this.ds.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.ds.addDataSourceProperty("useServerPrepStmts", "true");
    }

    @Override
    public void close() {
        this.ds.close();
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        if (Config.mb4) {
            connection.createStatement().executeQuery("SET NAMES utf8mb4");
        }
        return connection;
    }
}

