/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChatMessage;
import de.diddiz.LogBlock.Kill;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.SummedBlockChanges;
import de.diddiz.LogBlock.SummedKills;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LookupCacheElementFactory {
    private final QueryParams params;
    private final float spaceFactor;

    public LookupCacheElementFactory(QueryParams params, float spaceFactor) {
        this.params = params;
        this.spaceFactor = spaceFactor;
    }

    public LookupCacheElement getLookupCacheElement(ResultSet rs) throws SQLException {
        if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
            return new ChatMessage(rs, this.params);
        }
        if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
            if (this.params.sum == QueryParams.SummarizationMode.NONE) {
                return new Kill(rs, this.params);
            }
            if (this.params.sum == QueryParams.SummarizationMode.PLAYERS) {
                return new SummedKills(rs, this.params, this.spaceFactor);
            }
        }
        if (this.params.sum == QueryParams.SummarizationMode.NONE) {
            return new BlockChange(rs, this.params);
        }
        return new SummedBlockChanges(rs, this.params, this.spaceFactor);
    }
}

