/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.config;

import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.LoggingEnabledMapping;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class WorldConfig
extends LoggingEnabledMapping {
    public final String world;
    public final String table;
    public final String insertBlockStatementString;
    public final String selectBlockActorIdStatementString;
    public final String insertBlockStateStatementString;
    public final String insertBlockChestDataStatementString;

    public WorldConfig(String world, File file) throws IOException {
        this.world = world;
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("table", "lb-" + file.getName().substring(0, file.getName().length() - 4).replaceAll("[ ./\\\\]", "_"));
        for (Logging l : Logging.values()) {
            def.put("logging." + l.toString(), l.isDefaultEnabled());
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Map.Entry e : def.entrySet()) {
            if (config.get((String)e.getKey()) != null) continue;
            config.set((String)e.getKey(), e.getValue());
        }
        config.save(file);
        this.table = config.getString("table");
        for (Logging l : Logging.values()) {
            this.setLogging(l, config.getBoolean("logging." + l.toString()));
        }
        this.insertBlockStatementString = "INSERT INTO `" + this.table + "-blocks` (date, playerid, replaced, replaceddata, type, typedata, x, y, z) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?, ?)";
        this.selectBlockActorIdStatementString = "SELECT playerid FROM `" + this.table + "-blocks` WHERE x = ? AND y = ? AND z = ? ORDER BY date DESC LIMIT 1";
        this.insertBlockStateStatementString = "INSERT INTO `" + this.table + "-state` (replacedState, typeState, id) VALUES(?, ?, ?)";
        this.insertBlockChestDataStatementString = "INSERT INTO `" + this.table + "-chestdata` (item, itemremove, id, itemtype) values (?, ?, ?, ?)";
    }
}

