/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class ExplosionLogging
extends LoggingListener {
    private UUID lastBedInteractionPlayer;
    private Location lastBedInteractionLocation;
    private UUID lastRespawnAnchorInteractionPlayer;
    private Location lastRespawnAnchorInteractionLocation;

    public ExplosionLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getExplosionResult() == ExplosionResult.KEEP || event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        WorldConfig wcfg = Config.getWorldConfig(event.getLocation().getWorld());
        if (wcfg != null) {
            Actor actor = new Actor("Explosion");
            Entity source = event.getEntity();
            if (source == null) {
                if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                    return;
                }
            } else if (source instanceof TNTPrimed) {
                if (!wcfg.isLogging(Logging.TNTEXPLOSION)) {
                    return;
                }
                actor = new Actor("TNT");
            } else if (source instanceof ExplosiveMinecart) {
                if (!wcfg.isLogging(Logging.TNTMINECARTEXPLOSION)) {
                    return;
                }
                actor = new Actor("TNTMinecart");
            } else if (source instanceof Creeper) {
                LivingEntity target;
                if (!wcfg.isLogging(Logging.CREEPEREXPLOSION)) {
                    return;
                }
                actor = Config.logCreeperExplosionsAsPlayerWhoTriggeredThese ? ((target = ((Creeper)source).getTarget()) instanceof Player ? Actor.actorFromEntity((Entity)target) : new Actor("Creeper")) : new Actor("Creeper");
            } else if (source instanceof Wither) {
                if (!wcfg.isLogging(Logging.WITHER)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof WitherSkull) {
                if (!wcfg.isLogging(Logging.WITHER_SKULL)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof Fireball) {
                Fireball fireball = (Fireball)source;
                ProjectileSource shooter = fireball.getShooter();
                if (shooter == null) {
                    if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                        return;
                    }
                    actor = Actor.actorFromEntity(source);
                } else if (shooter instanceof Ghast) {
                    if (!wcfg.isLogging(Logging.GHASTFIREBALLEXPLOSION)) {
                        return;
                    }
                    actor = Actor.actorFromProjectileSource(shooter);
                } else if (shooter instanceof Wither) {
                    if (!wcfg.isLogging(Logging.WITHER)) {
                        return;
                    }
                    actor = Actor.actorFromProjectileSource(shooter);
                }
            } else if (source instanceof EnderDragon) {
                if (!wcfg.isLogging(Logging.ENDERDRAGON)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof EnderCrystal) {
                if (!wcfg.isLogging(Logging.ENDERCRYSTALEXPLOSION)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                return;
            }
            for (Block block : event.blockList()) {
                Material type = block.getType();
                if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.isContainerBlock(type) && !BukkitUtils.isShulkerBoxBlock(type)) {
                    this.consumer.queueContainerBreak(actor, block.getState());
                    continue;
                }
                this.consumer.queueBlockBreak(actor, block.getState());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.hasBlock()) {
            BlockData blockData;
            Block block = event.getClickedBlock();
            if (BukkitUtils.isBed(block.getType()) && !block.getWorld().isBedWorks()) {
                if (!Config.isLogging(block.getWorld(), Logging.BEDEXPLOSION)) {
                    return;
                }
                this.lastBedInteractionPlayer = event.getPlayer().getUniqueId();
                this.lastBedInteractionLocation = block.getLocation();
                new BukkitRunnable(){

                    public void run() {
                        ExplosionLogging.this.lastBedInteractionPlayer = null;
                        ExplosionLogging.this.lastBedInteractionLocation = null;
                    }
                }.runTask((Plugin)LogBlock.getInstance());
            } else if (block.getType() == Material.RESPAWN_ANCHOR && (blockData = block.getBlockData()) instanceof RespawnAnchor) {
                RespawnAnchor data = (RespawnAnchor)blockData;
                if (!Config.isLogging(block.getWorld(), Logging.RESPAWNANCHOREXPLOSION)) {
                    return;
                }
                ItemStack inHand = event.getItem();
                int charges = data.getCharges();
                if (charges < data.getMaximumCharges() && inHand != null && inHand.getType() == Material.GLOWSTONE) {
                    Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
                    RespawnAnchor blockNew = (RespawnAnchor)data.clone();
                    blockNew.setCharges(charges + 1);
                    this.consumer.queueBlockReplace(actor, block.getState(), (BlockData)blockNew);
                } else if (charges > 0 && !block.getWorld().isRespawnAnchorWorks()) {
                    Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
                    this.consumer.queueBlockBreak(actor, block.getState());
                    this.lastRespawnAnchorInteractionPlayer = event.getPlayer().getUniqueId();
                    this.lastRespawnAnchorInteractionLocation = block.getLocation();
                    new BukkitRunnable(){

                        public void run() {
                            ExplosionLogging.this.lastRespawnAnchorInteractionPlayer = null;
                            ExplosionLogging.this.lastRespawnAnchorInteractionLocation = null;
                        }
                    }.runTask((Plugin)LogBlock.getInstance());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        Location block;
        if (event.getExplosionResult() == ExplosionResult.KEEP || event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        Player bedCause = null;
        if (this.lastBedInteractionPlayer != null && this.lastBedInteractionLocation != null) {
            Location block2 = event.getBlock().getLocation();
            if (this.lastBedInteractionLocation.getWorld() == block2.getWorld() && block2.distanceSquared(this.lastBedInteractionLocation) <= 1.0) {
                bedCause = Bukkit.getPlayer((UUID)this.lastBedInteractionPlayer);
            }
        }
        Player respawnAnchorCause = null;
        if (this.lastRespawnAnchorInteractionPlayer != null && this.lastRespawnAnchorInteractionLocation != null && this.lastRespawnAnchorInteractionLocation.equals((Object)(block = event.getBlock().getLocation()))) {
            respawnAnchorCause = Bukkit.getPlayer((UUID)this.lastRespawnAnchorInteractionPlayer);
        }
        for (Block block3 : event.blockList()) {
            WorldConfig wcfg = Config.getWorldConfig(block3.getLocation().getWorld());
            if (wcfg == null) continue;
            Actor actor = new Actor("Explosion");
            if (bedCause != null) {
                if (!wcfg.isLogging(Logging.BEDEXPLOSION)) {
                    return;
                }
                actor = Config.logBedExplosionsAsPlayerWhoTriggeredThese ? Actor.actorFromEntity((Entity)bedCause) : new Actor("BedExplosion");
            } else if (respawnAnchorCause != null) {
                if (!wcfg.isLogging(Logging.RESPAWNANCHOREXPLOSION)) {
                    return;
                }
                actor = Config.logBedExplosionsAsPlayerWhoTriggeredThese ? Actor.actorFromEntity((Entity)respawnAnchorCause) : new Actor("RespawnAnchorExplosion");
            } else if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                return;
            }
            Material type = block3.getType();
            if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.isContainerBlock(type) && !BukkitUtils.isShulkerBoxBlock(type)) {
                this.consumer.queueContainerBreak(actor, block3.getState());
                continue;
            }
            this.consumer.queueBlockBreak(actor, block3.getState());
        }
    }
}

