/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;

public class KillLogging
extends LoggingListener {
    public KillLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent deathEvent) {
        if (Config.isLogging(deathEvent.getEntity().getWorld(), Logging.KILL)) {
            LivingEntity victim = deathEvent.getEntity();
            Entity killer = deathEvent.getDamageSource().getCausingEntity();
            if (killer != null) {
                if (!(Config.logKillsLevel != Config.LogKillsLevel.PLAYERS || victim instanceof Player && killer instanceof Player)) {
                    return;
                }
                if (!(Config.logKillsLevel != Config.LogKillsLevel.MONSTERS || (victim instanceof Player || victim instanceof Monster) && killer instanceof Player || killer instanceof Monster)) {
                    return;
                }
                this.consumer.queueKill(killer, (Entity)victim);
            } else if (Config.logEnvironmentalKills) {
                if (Config.logKillsLevel == Config.LogKillsLevel.PLAYERS && !(victim instanceof Player)) {
                    return;
                }
                if (Config.logKillsLevel == Config.LogKillsLevel.MONSTERS && !(victim instanceof Player) && !(victim instanceof Monster)) {
                    return;
                }
                this.consumer.queueKill(new Actor(deathEvent.getDamageSource().getDamageType().toString()), (Entity)victim);
            }
        }
    }
}

