/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import com.zaxxer.hikari.HikariDataSource;
import de.diddiz.LogBlock.config.Config;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQLConnectionPool
implements Closeable {
    private final HikariDataSource ds = new HikariDataSource();

    public MySQLConnectionPool(String url, String user, String password) {
        this.ds.setJdbcUrl(url);
        this.ds.setUsername(user);
        this.ds.setPassword(password);
        this.ds.setMinimumIdle(2);
        this.ds.setMaximumPoolSize(15);
        this.ds.setPoolName("LogBlock-Connection-Pool");
        this.ds.addDataSourceProperty("useUnicode", (Object)"true");
        this.ds.addDataSourceProperty("characterEncoding", (Object)"utf-8");
        this.ds.addDataSourceProperty("rewriteBatchedStatements", (Object)"true");
        this.ds.addDataSourceProperty("cachePrepStmts", (Object)"true");
        this.ds.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        this.ds.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.ds.addDataSourceProperty("useServerPrepStmts", (Object)"true");
    }

    @Override
    public void close() {
        this.ds.close();
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        if (Config.mb4) {
            connection.createStatement().executeQuery("SET NAMES utf8mb4");
        }
        return connection;
    }
}

