/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;

public class BlockStateCodecSpawner
implements BlockStateCodec {
    @Override
    public Material[] getApplicableMaterials() {
        return new Material[]{Material.SPAWNER};
    }

    @Override
    public YamlConfiguration serialize(BlockState state) {
        if (state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)state;
            YamlConfiguration conf = new YamlConfiguration();
            conf.set("delay", (Object)spawner.getDelay());
            conf.set("maxNearbyEntities", (Object)spawner.getMaxNearbyEntities());
            conf.set("maxSpawnDelay", (Object)spawner.getMaxSpawnDelay());
            conf.set("minSpawnDelay", (Object)spawner.getMinSpawnDelay());
            conf.set("requiredPlayerRange", (Object)spawner.getRequiredPlayerRange());
            conf.set("spawnCount", (Object)spawner.getSpawnCount());
            conf.set("spawnedType", (Object)spawner.getSpawnedType().name());
            conf.set("spawnRange", (Object)spawner.getSpawnRange());
            return conf;
        }
        return null;
    }

    @Override
    public void deserialize(BlockState state, YamlConfiguration conf) {
        if (state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)state;
            if (conf != null) {
                spawner.setDelay(conf.getInt("delay"));
                spawner.setMaxNearbyEntities(conf.getInt("maxNearbyEntities"));
                spawner.setMaxSpawnDelay(conf.getInt("maxSpawnDelay"));
                spawner.setMinSpawnDelay(conf.getInt("minSpawnDelay"));
                spawner.setRequiredPlayerRange(conf.getInt("requiredPlayerRange"));
                spawner.setSpawnCount(conf.getInt("spawnCount"));
                spawner.setSpawnedType(EntityType.valueOf((String)conf.getString("spawnedType")));
                spawner.setSpawnRange(conf.getInt("spawnRange"));
            }
        }
    }

    @Override
    public String toString(YamlConfiguration conf, YamlConfiguration oldState) {
        EntityType entity;
        if (conf != null && (entity = EntityType.valueOf((String)conf.getString("spawnedType"))) != null) {
            return "[" + entity + "]";
        }
        return null;
    }
}

