/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.config;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.EntityLogging;
import de.diddiz.LogBlock.config.LoggingEnabledMapping;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;

public class WorldConfig
extends LoggingEnabledMapping {
    public final String world;
    public final String table;
    public final String insertBlockStatementString;
    public final String selectBlockActorIdStatementString;
    public final String insertBlockStateStatementString;
    public final String insertBlockChestDataStatementString;
    public final String insertEntityStatementString;
    public final String updateEntityUUIDString;
    private final EnumMap<EntityLogging, EntityLoggingList> entityLogging = new EnumMap(EntityLogging.class);
    public final boolean logNaturalEntitySpawns;
    public final boolean logAllNamedEntityKills;

    public WorldConfig(String world, File file) throws IOException {
        this.world = world;
        HashMap<Object, Object> def = new HashMap<Object, Object>();
        def.put("table", "lb-" + file.getName().substring(0, file.getName().length() - 4).replaceAll("[ ./\\\\]", "_"));
        for (Logging l : Logging.values()) {
            def.put("logging." + l.toString(), l.isDefaultEnabled());
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Map.Entry e : def.entrySet()) {
            if (config.get((String)e.getKey()) != null) continue;
            config.set((String)e.getKey(), e.getValue());
        }
        for (EntityLogging entityLogging : EntityLogging.values()) {
            if (!(config.get("entity." + entityLogging.name().toLowerCase()) instanceof List)) {
                config.set("entity." + entityLogging.name().toLowerCase(), entityLogging.getDefaultEnabled());
            }
            this.entityLogging.put(entityLogging, new EntityLoggingList(entityLogging, config.getStringList("entity." + entityLogging.name().toLowerCase())));
        }
        if (!config.isBoolean("entity.logNaturalSpawns")) {
            config.set("entity.logNaturalSpawns", (Object)false);
        }
        this.logNaturalEntitySpawns = config.getBoolean("entity.logNaturalSpawns");
        if (!config.isBoolean("entity.logAllNamedEntityKills")) {
            config.set("entity.logAllNamedEntityKills", (Object)true);
        }
        this.logAllNamedEntityKills = config.getBoolean("entity.logAllNamedEntityKills");
        config.save(file);
        this.table = config.getString("table");
        for (Enum enum_ : Logging.values()) {
            this.setLogging((Logging)enum_, config.getBoolean("logging." + enum_.toString()));
        }
        this.insertBlockStatementString = "INSERT INTO `" + this.table + "-blocks` (date, playerid, replaced, replaceddata, type, typedata, x, y, z) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?, ?)";
        this.selectBlockActorIdStatementString = "SELECT playerid FROM `" + this.table + "-blocks` WHERE x = ? AND y = ? AND z = ? ORDER BY date DESC LIMIT 1";
        this.insertBlockStateStatementString = "INSERT INTO `" + this.table + "-state` (replacedState, typeState, id) VALUES(?, ?, ?)";
        this.insertBlockChestDataStatementString = "INSERT INTO `" + this.table + "-chestdata` (item, itemremove, id, itemtype) values (?, ?, ?, ?)";
        this.insertEntityStatementString = "INSERT INTO `" + this.table + "-entities` (date, playerid, entityid, entitytypeid, x, y, z, action, data) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?, ?)";
        this.updateEntityUUIDString = "UPDATE `" + this.table + "-entityids` SET entityuuid = ? WHERE entityid = ?";
    }

    public boolean isLogging(EntityLogging logging, Entity entity) {
        return this.entityLogging.get((Object)logging).isLogging(entity);
    }

    public boolean isLoggingAnyEntities() {
        for (EntityLoggingList list : this.entityLogging.values()) {
            if (!list.isLoggingAnyEntities()) continue;
            return true;
        }
        return false;
    }

    private class EntityLoggingList {
        private EntityLogging entityAction;
        private final EnumSet<EntityType> logged = EnumSet.noneOf(EntityType.class);
        private final boolean logAll;
        private final boolean logAnimals;
        private final boolean logMonsters;
        private final boolean logLiving;

        public EntityLoggingList(EntityLogging entityAction, List<String> types) {
            this.entityAction = entityAction;
            boolean all = false;
            boolean animals = false;
            boolean monsters = false;
            boolean living = false;
            for (String type : types) {
                EntityType et = BukkitUtils.matchEntityType(type);
                if (et != null) {
                    this.logged.add(et);
                    continue;
                }
                if (type.equalsIgnoreCase("all")) {
                    all = true;
                    continue;
                }
                if (type.equalsIgnoreCase("animal") || type.equalsIgnoreCase("animals")) {
                    animals = true;
                    continue;
                }
                if (type.equalsIgnoreCase("monster") || type.equalsIgnoreCase("monsters")) {
                    monsters = true;
                    continue;
                }
                if (type.equalsIgnoreCase("living")) {
                    living = true;
                    continue;
                }
                LogBlock.getInstance().getLogger().log(Level.WARNING, "Unkown entity type in config for " + WorldConfig.this.world + ": " + type);
            }
            this.logAll = all;
            this.logAnimals = animals;
            this.logMonsters = monsters;
            this.logLiving = living;
        }

        public boolean isLogging(Entity entity) {
            if (entity == null || entity instanceof Player) {
                return false;
            }
            EntityType type = entity.getType();
            if (this.logAll || this.logged.contains(type)) {
                return true;
            }
            if (this.logLiving && LivingEntity.class.isAssignableFrom(entity.getClass()) && !(entity instanceof ArmorStand)) {
                return true;
            }
            if (this.logAnimals && (Animals.class.isAssignableFrom(entity.getClass()) || WaterMob.class.isAssignableFrom(entity.getClass()))) {
                return true;
            }
            if (this.logMonsters && (Monster.class.isAssignableFrom(entity.getClass()) || entity.getType() == EntityType.SLIME || entity.getType() == EntityType.WITHER || entity.getType() == EntityType.ENDER_DRAGON || entity.getType() == EntityType.SHULKER || entity.getType() == EntityType.GHAST)) {
                return true;
            }
            return this.entityAction == EntityLogging.DESTROY && WorldConfig.this.logAllNamedEntityKills && entity.getCustomName() != null;
        }

        public boolean isLoggingAnyEntities() {
            return this.logAll || this.logAnimals || this.logLiving || this.logMonsters || !this.logged.isEmpty() || this.entityAction == EntityLogging.DESTROY && WorldConfig.this.logAllNamedEntityKills;
        }
    }
}

