/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.LookupCacheElementFactory;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolData;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.WorldEditor;
import de.diddiz.LogBlock.WorldEditorEditFactory;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.MessagingUtil;
import de.diddiz.LogBlock.util.TypeColor;
import de.diddiz.LogBlock.util.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class CommandsHandler
implements CommandExecutor {
    private final LogBlock logblock;
    private final BukkitScheduler scheduler;

    CommandsHandler(LogBlock logblock) {
        this.logblock = logblock;
        this.scheduler = logblock.getServer().getScheduler();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        block117: {
            try {
                if (args.length == 0) {
                    sender.sendMessage(org.bukkit.ChatColor.YELLOW + "------------------[ " + org.bukkit.ChatColor.WHITE + "LogBlock" + org.bukkit.ChatColor.YELLOW + " ]-------------------");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "LogBlock " + org.bukkit.ChatColor.WHITE + "v" + this.logblock.getDescription().getVersion() + org.bukkit.ChatColor.GOLD + " by DiddiZ");
                    TextComponent message = MessagingUtil.createTextComponentWithColor("Type ", ChatColor.GOLD);
                    TextComponent clickable = MessagingUtil.createTextComponentWithColor("/lb help", ChatColor.WHITE);
                    clickable.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lb help"));
                    message.addExtra((BaseComponent)clickable);
                    message.addExtra(" for help");
                    sender.spigot().sendMessage((BaseComponent)message);
                    break block117;
                }
                String command = args[0].toLowerCase();
                if (command.equals("help")) {
                    sender.sendMessage(org.bukkit.ChatColor.YELLOW + "----------------[ " + org.bukkit.ChatColor.WHITE + "LogBlock Help" + org.bukkit.ChatColor.YELLOW + " ]----------------");
                    TextComponent message = MessagingUtil.createTextComponentWithColor("For the commands list type ", ChatColor.GOLD);
                    TextComponent clickable = MessagingUtil.createTextComponentWithColor("/lb commands", ChatColor.WHITE);
                    clickable.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lb commands"));
                    message.addExtra((BaseComponent)clickable);
                    sender.spigot().sendMessage((BaseComponent)message);
                    message = MessagingUtil.createTextComponentWithColor("For the parameters list type ", ChatColor.GOLD);
                    clickable = MessagingUtil.createTextComponentWithColor("/lb params", ChatColor.WHITE);
                    clickable.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lb params"));
                    message.addExtra((BaseComponent)clickable);
                    sender.spigot().sendMessage((BaseComponent)message);
                    message = MessagingUtil.createTextComponentWithColor("For the list of permissions you got type ", ChatColor.GOLD);
                    clickable = MessagingUtil.createTextComponentWithColor("/lb permissions", ChatColor.WHITE);
                    clickable.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lb permissions"));
                    message.addExtra((BaseComponent)clickable);
                    sender.spigot().sendMessage((BaseComponent)message);
                    break block117;
                }
                if (command.equals("commands")) {
                    sender.sendMessage(org.bukkit.ChatColor.YELLOW + "--------------[ " + org.bukkit.ChatColor.WHITE + "LogBlock Commands" + org.bukkit.ChatColor.YELLOW + " ]--------------");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb tool " + org.bukkit.ChatColor.WHITE + "-- Gives you the lb tool");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb tool [on|off] " + org.bukkit.ChatColor.WHITE + "-- Enables/Disables tool");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb tool [params] " + org.bukkit.ChatColor.WHITE + "-- Sets the tool lookup query");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb tool default " + org.bukkit.ChatColor.WHITE + "-- Sets the tool lookup query to default");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb toolblock " + org.bukkit.ChatColor.WHITE + "-- Analog to tool");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb hide " + org.bukkit.ChatColor.WHITE + "-- Hides you from log");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb rollback [params] " + org.bukkit.ChatColor.WHITE + "-- Rollback");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb redo [params] " + org.bukkit.ChatColor.WHITE + "-- Redo");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb tp [params] " + org.bukkit.ChatColor.WHITE + "-- Teleports you to the location of griefing");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb writelogfile [params] " + org.bukkit.ChatColor.WHITE + "-- Writes a log file");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb lookup [params] " + org.bukkit.ChatColor.WHITE + "-- Lookup");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb prev|next " + org.bukkit.ChatColor.WHITE + "-- Browse lookup result pages");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb page " + org.bukkit.ChatColor.WHITE + "-- Shows a specific lookup result page");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "/lb me " + org.bukkit.ChatColor.WHITE + "-- Displays your stats");
                    sender.sendMessage("");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "Look at " + org.bukkit.ChatColor.WHITE + "github.com/LogBlock/LogBlock/wiki/Commands" + org.bukkit.ChatColor.GOLD + " for the full commands reference");
                    break block117;
                }
                if (command.equals("params")) {
                    sender.sendMessage(org.bukkit.ChatColor.YELLOW + "----------[ " + org.bukkit.ChatColor.WHITE + "LogBlock Query Parameters" + org.bukkit.ChatColor.YELLOW + " ]----------");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "Use doublequotes to escape a keyword: world \"world\"");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "player [name1] <name2> <name3> " + org.bukkit.ChatColor.WHITE + "-- List of players");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "block [type1] <type2> <type3> " + org.bukkit.ChatColor.WHITE + "-- List of block types");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "created, destroyed " + org.bukkit.ChatColor.WHITE + "-- Show only created/destroyed blocks");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "chestaccess " + org.bukkit.ChatColor.WHITE + "-- Show only chest accesses");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "entities [type1] <type2> <type3> " + org.bukkit.ChatColor.WHITE + "-- List of entity types; can not be combined with blocks");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "area <radius> " + org.bukkit.ChatColor.WHITE + "-- Area around you");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "selection, sel " + org.bukkit.ChatColor.WHITE + "-- Inside current WorldEdit selection");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "world [worldname] " + org.bukkit.ChatColor.WHITE + "-- Changes the world");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "time [number] [minutes|hours|days] " + org.bukkit.ChatColor.WHITE + "-- Limits time");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "since <dd.MM.yyyy> <HH:mm:ss> " + org.bukkit.ChatColor.WHITE + "-- Limits time to a fixed point");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "before <dd.MM.yyyy> <HH:mm:ss> " + org.bukkit.ChatColor.WHITE + "-- Affects only blocks before a fixed time");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "force " + org.bukkit.ChatColor.WHITE + "-- Forces replacing not matching blocks");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "limit <row count> " + org.bukkit.ChatColor.WHITE + "-- Limits the result to count of rows");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "sum [none|blocks|players] " + org.bukkit.ChatColor.WHITE + "-- Sums the result");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "asc, desc " + org.bukkit.ChatColor.WHITE + "-- Changes the order of the displayed log");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "coords " + org.bukkit.ChatColor.WHITE + "-- Shows coordinates for each block");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "nocache " + org.bukkit.ChatColor.WHITE + "-- Don't set the lookup cache");
                    sender.sendMessage(org.bukkit.ChatColor.GOLD + "silent " + org.bukkit.ChatColor.WHITE + "-- Displays lesser messages");
                    break block117;
                }
                if (command.equals("permissions")) {
                    sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "You've got the following permissions:");
                    for (String permission : new String[]{"me", "lookup", "tp", "rollback", "clearlog", "hide", "ignoreRestrictions", "spawnTools"}) {
                        if (!this.logblock.hasPermission(sender, "logblock." + permission)) continue;
                        sender.sendMessage(org.bukkit.ChatColor.GOLD + "logblock." + permission);
                    }
                    for (Tool tool : Config.toolsByType.values()) {
                        if (!this.logblock.hasPermission(sender, "logblock.tools." + tool.name)) continue;
                        sender.sendMessage(org.bukkit.ChatColor.GOLD + "logblock.tools." + tool.name);
                    }
                    break block117;
                }
                if (command.equals("logging")) {
                    if (this.logblock.hasPermission(sender, "logblock.lookup")) {
                        World world = null;
                        if (args.length > 1) {
                            world = this.logblock.getServer().getWorld(args[1]);
                        } else if (sender instanceof Player) {
                            world = ((Player)sender).getWorld();
                        }
                        if (world != null) {
                            WorldConfig wcfg = Config.getWorldConfig(world.getName());
                            if (wcfg != null) {
                                sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "Currently logging in " + world.getName() + ":");
                                ArrayList<String> logging = new ArrayList<String>();
                                for (Logging l : Logging.values()) {
                                    if (!wcfg.isLogging(l)) continue;
                                    logging.add(l.toString());
                                }
                                sender.sendMessage(org.bukkit.ChatColor.GOLD + Utils.listing(logging, ", ", " and "));
                            } else {
                                sender.sendMessage(org.bukkit.ChatColor.RED + "World not logged: '" + world.getName() + "'");
                                sender.sendMessage(org.bukkit.ChatColor.LIGHT_PURPLE + "Make the world name is listed at loggedWorlds in config. World names are case sensitive and must contains the path (if any), exactly like in the message above.");
                            }
                        } else {
                            sender.sendMessage(org.bukkit.ChatColor.RED + "No world specified");
                        }
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    }
                    break block117;
                }
                if (Config.toolsByName.get(command) != null) {
                    Tool tool = Config.toolsByName.get(command);
                    if (this.logblock.hasPermission(sender, "logblock.tools." + tool.name)) {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            Session session = Session.getSession((CommandSender)player);
                            ToolData toolData = session.toolData.get(tool);
                            if (args.length == 1) {
                                if (this.logblock.hasPermission((CommandSender)player, "logblock.spawnTools")) {
                                    BukkitUtils.giveTool(player, tool.item);
                                    toolData.enabled = true;
                                } else {
                                    sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                                }
                                break block117;
                            }
                            if (args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("on")) {
                                toolData.enabled = true;
                                player.sendMessage(org.bukkit.ChatColor.GREEN + "Tool enabled.");
                                break block117;
                            }
                            if (args[1].equalsIgnoreCase("disable") || args[1].equalsIgnoreCase("off")) {
                                ItemStack offhandItem;
                                toolData.enabled = false;
                                if (tool.removeOnDisable && this.logblock.hasPermission((CommandSender)player, "logblock.spawnTools") && !player.getInventory().removeItem(new ItemStack[]{new ItemStack(tool.item, 1)}).isEmpty() && (offhandItem = player.getInventory().getItemInOffHand()) != null && offhandItem.isSimilar(new ItemStack(tool.item, 1))) {
                                    if (offhandItem.getAmount() <= 1) {
                                        player.getInventory().setItemInOffHand(null);
                                    } else {
                                        offhandItem.setAmount(offhandItem.getAmount() - 1);
                                        player.getInventory().setItemInOffHand(offhandItem);
                                    }
                                }
                                player.sendMessage(org.bukkit.ChatColor.GREEN + "Tool disabled.");
                                break block117;
                            }
                            if (args[1].equalsIgnoreCase("mode")) {
                                if (args.length == 3) {
                                    ToolMode mode;
                                    try {
                                        mode = ToolMode.valueOf(args[2].toUpperCase());
                                    }
                                    catch (IllegalArgumentException ex) {
                                        sender.sendMessage(org.bukkit.ChatColor.RED + "Can't find mode " + args[2]);
                                        return true;
                                    }
                                    if (this.logblock.hasPermission((CommandSender)player, mode.getPermission())) {
                                        toolData.mode = mode;
                                        sender.sendMessage(org.bukkit.ChatColor.GREEN + "Tool mode set to " + args[2]);
                                    } else {
                                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to use mode " + args[2]);
                                    }
                                    break block117;
                                }
                                player.sendMessage(org.bukkit.ChatColor.RED + "No mode specified");
                                break block117;
                            }
                            if (args[1].equalsIgnoreCase("default")) {
                                toolData.params = tool.params.clone();
                                toolData.mode = tool.mode;
                                sender.sendMessage(org.bukkit.ChatColor.GREEN + "Tool set to default.");
                            } else if (this.logblock.hasPermission((CommandSender)player, "logblock.lookup")) {
                                try {
                                    QueryParams params = tool.params.clone();
                                    params.parseArgs(sender, CommandsHandler.argsToList(args, 1));
                                    toolData.params = params;
                                    sender.sendMessage(org.bukkit.ChatColor.GREEN + "Set tool query to: " + params.getTitle());
                                }
                                catch (Exception ex) {
                                    sender.sendMessage(org.bukkit.ChatColor.RED + ex.getMessage());
                                }
                            } else {
                                sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                            }
                            break block117;
                        }
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You have to be a player.");
                        break block117;
                    }
                    sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    break block117;
                }
                if (command.equals("hide")) {
                    if (sender instanceof Player) {
                        if (this.logblock.hasPermission(sender, "logblock.hide")) {
                            if (args.length == 2) {
                                if (args[1].equalsIgnoreCase("on")) {
                                    Consumer.hide((Player)sender);
                                    sender.sendMessage(org.bukkit.ChatColor.GREEN + "You are now hidden and aren't logged. Type /lb hide to unhide.");
                                } else if (args[1].equalsIgnoreCase("off")) {
                                    Consumer.unHide((Player)sender);
                                    sender.sendMessage(org.bukkit.ChatColor.GREEN + "You aren't hidden any longer.");
                                }
                            } else if (Consumer.toggleHide((Player)sender)) {
                                sender.sendMessage(org.bukkit.ChatColor.GREEN + "You are now hidden and aren't logged. Type '/lb hide' again to unhide.");
                            } else {
                                sender.sendMessage(org.bukkit.ChatColor.GREEN + "You aren't hidden any longer.");
                            }
                        } else {
                            sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                        }
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You have to be a player.");
                    }
                } else if (command.equals("page")) {
                    if (args.length == 2 && Utils.isInt(args[1])) {
                        CommandsHandler.showPage(sender, Integer.valueOf(args[1]));
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You have to specify a page");
                    }
                } else if (command.equals("next") || command.equals("+")) {
                    CommandsHandler.showPage(sender, Session.getSession((CommandSender)sender).page + 1);
                } else if (command.equals("prev") || command.equals("-")) {
                    CommandsHandler.showPage(sender, Session.getSession((CommandSender)sender).page - 1);
                } else if (args[0].equalsIgnoreCase("savequeue")) {
                    if (this.logblock.hasPermission(sender, "logblock.rollback")) {
                        new CommandSaveQueue(sender, null, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (args[0].equalsIgnoreCase("queuesize")) {
                    if (this.logblock.hasPermission(sender, "logblock.rollback")) {
                        sender.sendMessage("Current queue size: " + this.logblock.getConsumer().getQueueSize());
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (command.equals("rollback") || command.equals("undo") || command.equals("rb")) {
                    if (this.logblock.hasPermission(sender, "logblock.rollback")) {
                        QueryParams params = new QueryParams(this.logblock);
                        params.since = Config.defaultTime;
                        params.bct = QueryParams.BlockChangeType.ALL;
                        params.parseArgs(sender, CommandsHandler.argsToList(args, 1));
                        new CommandRollback(sender, params, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (command.equals("redo")) {
                    if (this.logblock.hasPermission(sender, "logblock.rollback")) {
                        QueryParams params = new QueryParams(this.logblock);
                        params.since = Config.defaultTime;
                        params.bct = QueryParams.BlockChangeType.ALL;
                        params.parseArgs(sender, CommandsHandler.argsToList(args, 1));
                        new CommandRedo(sender, params, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (command.equals("me")) {
                    if (sender instanceof Player) {
                        if (this.logblock.hasPermission(sender, "logblock.me")) {
                            Player player = (Player)sender;
                            if (Config.isLogged(player.getWorld())) {
                                QueryParams params = new QueryParams(this.logblock);
                                params.setPlayer(player.getName());
                                params.world = player.getWorld();
                                params.sum = QueryParams.SummarizationMode.TYPES;
                                new CommandLookup(sender, params, true);
                            } else {
                                sender.sendMessage(org.bukkit.ChatColor.RED + "This world isn't logged");
                            }
                        } else {
                            sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this.");
                        }
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You have to be a player.");
                    }
                } else if (command.equals("writelogfile")) {
                    if (this.logblock.hasPermission(sender, "logblock.rollback")) {
                        QueryParams params = new QueryParams(this.logblock);
                        params.limit = -1;
                        params.bct = QueryParams.BlockChangeType.ALL;
                        params.parseArgs(sender, CommandsHandler.argsToList(args, 1));
                        new CommandWriteLogFile(sender, params, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this");
                    }
                } else if (command.equals("clearlog")) {
                    if (this.logblock.hasPermission(sender, "logblock.clearlog")) {
                        QueryParams params = new QueryParams(this.logblock);
                        params.limit = -1;
                        params.bct = QueryParams.BlockChangeType.ALL;
                        params.parseArgs(sender, CommandsHandler.argsToList(args, 1));
                        new CommandClearLog(sender, params, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this");
                    }
                } else if (command.equals("tp")) {
                    if (sender instanceof Player) {
                        if (this.logblock.hasPermission(sender, "logblock.tp")) {
                            if (args.length == 2 || Utils.isInt(args[1])) {
                                int pos = Integer.parseInt(args[1]) - 1;
                                Player player = (Player)sender;
                                Session session = Session.getSession((CommandSender)player);
                                if (session.lookupCache != null) {
                                    if (pos >= 0 && pos < session.lookupCache.length) {
                                        Location loc = session.lookupCache[pos].getLocation();
                                        if (loc != null) {
                                            player.teleport(new Location(loc.getWorld(), loc.getX() + 0.5, (double)BukkitUtils.saveSpawnHeight(loc), loc.getZ() + 0.5, player.getLocation().getYaw(), 90.0f));
                                            player.sendMessage(org.bukkit.ChatColor.LIGHT_PURPLE + "Teleported to " + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ());
                                        } else {
                                            sender.sendMessage(org.bukkit.ChatColor.RED + "There is no location associated with that. Did you forget coords parameter?");
                                        }
                                    } else {
                                        sender.sendMessage(org.bukkit.ChatColor.RED + "'" + args[1] + " is out of range");
                                    }
                                } else {
                                    sender.sendMessage(org.bukkit.ChatColor.RED + "You havn't done a lookup yet");
                                }
                            } else {
                                new CommandTeleport(sender, new QueryParams(this.logblock, sender, CommandsHandler.argsToList(args, 1)), true);
                            }
                        } else {
                            sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this");
                        }
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You have to be a player.");
                    }
                } else if (command.equals("lookup") || QueryParams.isKeyWord(args[0])) {
                    if (this.logblock.hasPermission(sender, "logblock.lookup")) {
                        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
                        if (command.equals("lookup")) {
                            argsList.remove(0);
                        }
                        QueryParams params = new QueryParams(this.logblock);
                        params.since = Config.defaultTime;
                        params.bct = QueryParams.BlockChangeType.ALL;
                        params.limit = Config.linesLimit;
                        params.parseArgs(sender, argsList);
                        new CommandLookup(sender, params, true);
                    } else {
                        sender.sendMessage(org.bukkit.ChatColor.RED + "You aren't allowed to do this");
                    }
                } else {
                    sender.sendMessage(org.bukkit.ChatColor.RED + "Unknown command '" + args[0] + "'");
                }
            }
            catch (IllegalArgumentException ex) {
                sender.sendMessage(org.bukkit.ChatColor.RED + ex.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                sender.sendMessage(org.bukkit.ChatColor.RED + "Not enough arguments given");
            }
            catch (Exception ex) {
                sender.sendMessage(org.bukkit.ChatColor.RED + "Error, check server.log");
                this.logblock.getLogger().log(Level.WARNING, "Exception in commands handler: ", ex);
            }
        }
        return true;
    }

    private static void showPage(CommandSender sender, int page) {
        CommandsHandler.showPage(sender, page, Session.getSession((CommandSender)sender).lookupCache, true);
    }

    private static void showPage(CommandSender sender, int page, LookupCacheElement[] lookupElements, boolean setSessionPage) {
        if (lookupElements != null && lookupElements.length > 0) {
            int startpos = (page - 1) * Config.linesPerPage;
            if (page > 0 && startpos <= lookupElements.length - 1) {
                int stoppos = startpos + Config.linesPerPage >= lookupElements.length ? lookupElements.length - 1 : startpos + Config.linesPerPage - 1;
                int numberOfPages = (int)Math.ceil((double)lookupElements.length / (double)Config.linesPerPage);
                if (numberOfPages != 1) {
                    sender.sendMessage(TypeColor.HEADER + "Page " + page + "/" + numberOfPages);
                }
                for (int i = startpos; i <= stoppos; ++i) {
                    TextComponent message = new TextComponent();
                    message.setColor(TypeColor.DEFAULT.getColor());
                    if (lookupElements[i].getLocation() != null) {
                        message.addExtra((BaseComponent)new TextComponent("(" + (i + 1) + ") "));
                    }
                    for (BaseComponent component : lookupElements[i].getLogMessage(i + 1)) {
                        message.addExtra(component);
                    }
                    sender.spigot().sendMessage((BaseComponent)message);
                }
                if (setSessionPage) {
                    Session.getSession((CommandSender)sender).page = page;
                }
            } else {
                sender.sendMessage(TypeColor.ERROR + "There isn't a page '" + page + "'");
            }
        } else {
            sender.sendMessage(TypeColor.ERROR + "No blocks in lookup cache");
        }
    }

    private boolean checkRestrictions(CommandSender sender, QueryParams params) {
        if (sender.isOp() || this.logblock.hasPermission(sender, "logblock.ignoreRestrictions")) {
            return true;
        }
        if (Config.rollbackMaxTime > 0 && (params.since <= 0 || params.since > Config.rollbackMaxTime)) {
            sender.sendMessage(org.bukkit.ChatColor.RED + "You are not allowed to rollback more than " + Config.rollbackMaxTime + " minutes");
            return false;
        }
        if (Config.rollbackMaxArea > 0 && (params.sel == null && params.loc == null || params.radius > Config.rollbackMaxArea || params.sel != null && (params.sel.getSizeX() > Config.rollbackMaxArea || params.sel.getSizeZ() > Config.rollbackMaxArea))) {
            sender.sendMessage(org.bukkit.ChatColor.RED + "You are not allowed to rollback an area larger than " + Config.rollbackMaxArea + " blocks");
            return false;
        }
        return true;
    }

    private ResultSet executeQuery(Statement state, String query) throws SQLException {
        if (Config.debug) {
            long startTime = System.currentTimeMillis();
            ResultSet rs = state.executeQuery(query);
            this.logblock.getLogger().log(Level.INFO, "[LogBlock Debug] Time Taken: " + (System.currentTimeMillis() - startTime) + " milliseconds. Query: " + query);
            return rs;
        }
        return state.executeQuery(query);
    }

    private static List<String> argsToList(String[] arr, int offset) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr));
        for (int i = 0; i < offset; ++i) {
            list.remove(0);
        }
        return list;
    }

    public class CommandSaveQueue
    extends AbstractCommand {
        public CommandSaveQueue(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        @Override
        public void run() {
            Consumer consumer = CommandsHandler.this.logblock.getConsumer();
            this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "Current queue size: " + consumer.getQueueSize());
        }
    }

    public class CommandRollback
    extends AbstractCommand {
        public CommandRollback(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Chat cannot be rolled back");
                    return;
                }
                if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Kills cannot be rolled back");
                    return;
                }
                if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Cannot rollback summarized changes");
                    return;
                }
                this.params.needDate = true;
                this.params.needCoords = true;
                this.params.needType = true;
                this.params.needData = true;
                this.params.needChestAccess = true;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                if (this.conn == null) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                    return;
                }
                this.state = this.conn.createStatement();
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                if (!this.params.silent) {
                    this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                }
                this.rs = CommandsHandler.this.executeQuery(this.state, this.params.getQuery());
                WorldEditor editor = new WorldEditor(CommandsHandler.this.logblock, this.params.world, this.params.forceReplace);
                WorldEditorEditFactory editFactory = new WorldEditorEditFactory(editor, this.params, true);
                while (this.rs.next()) {
                    editFactory.processRow(this.rs);
                }
                if (this.params.order == QueryParams.Order.DESC) {
                    editor.reverseRowOrder();
                }
                editor.sortRows(QueryParams.Order.DESC);
                int changes = editor.getSize();
                if (changes > 10000) {
                    editor.setSender(this.sender);
                }
                if (!this.params.silent) {
                    this.sender.sendMessage(org.bukkit.ChatColor.GREEN.toString() + changes + " " + (this.params.bct == QueryParams.BlockChangeType.ENTITIES ? "entities" : "blocks") + " found.");
                }
                if (changes == 0) {
                    if (!this.params.silent) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "Rollback aborted");
                    }
                    return;
                }
                if (!this.params.silent && Config.askRollbacks && this.sender instanceof Player && !CommandsHandler.this.logblock.getQuestioner().ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Rollback aborted");
                    return;
                }
                editor.start();
                if (!this.params.noCache) {
                    Session.getSession((CommandSender)this.sender).lookupCache = editor.errors;
                }
                this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "Rollback finished successfully (" + editor.getElapsedTime() + " ms, " + editor.getSuccesses() + "/" + changes + " blocks" + (String)(editor.getErrors() > 0 ? ", " + org.bukkit.ChatColor.RED + editor.getErrors() + " errors" + org.bukkit.ChatColor.GREEN : "") + (String)(editor.getBlacklistCollisions() > 0 ? ", " + editor.getBlacklistCollisions() + " blacklist collisions" : "") + ")");
                if (!this.params.silent && Config.askClearLogAfterRollback && CommandsHandler.this.logblock.hasPermission(this.sender, "logblock.clearlog") && this.sender instanceof Player) {
                    Thread.sleep(1000L);
                    if (CommandsHandler.this.logblock.getQuestioner().ask((Player)this.sender, "Do you want to delete the rollbacked log?", "yes", "no").equals("yes")) {
                        this.params.silent = true;
                        new CommandClearLog(this.sender, this.params, false);
                    } else {
                        this.sender.sendMessage(org.bukkit.ChatColor.LIGHT_PURPLE + "Clearlog cancelled");
                    }
                }
            }
            catch (Exception ex) {
                if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[Rollback] " + this.params.getQuery() + ": ", ex);
                }
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandRedo
    extends AbstractCommand {
        public CommandRedo(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Chat cannot be redone");
                    return;
                }
                if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Kills cannot be redone");
                    return;
                }
                if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Cannot redo summarized changes");
                    return;
                }
                this.params.needDate = true;
                this.params.needCoords = true;
                this.params.needType = true;
                this.params.needData = true;
                this.params.needChestAccess = true;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                if (this.conn == null) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                    return;
                }
                this.state = this.conn.createStatement();
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                this.rs = CommandsHandler.this.executeQuery(this.state, this.params.getQuery());
                if (!this.params.silent) {
                    this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                }
                WorldEditor editor = new WorldEditor(CommandsHandler.this.logblock, this.params.world, this.params.forceReplace);
                WorldEditorEditFactory editFactory = new WorldEditorEditFactory(editor, this.params, false);
                while (this.rs.next()) {
                    editFactory.processRow(this.rs);
                }
                if (this.params.order == QueryParams.Order.ASC) {
                    editor.reverseRowOrder();
                }
                editor.sortRows(QueryParams.Order.ASC);
                int changes = editor.getSize();
                if (!this.params.silent) {
                    this.sender.sendMessage(org.bukkit.ChatColor.GREEN.toString() + changes + " " + (this.params.bct == QueryParams.BlockChangeType.ENTITIES ? "entities" : "blocks") + " found.");
                }
                if (changes == 0) {
                    if (!this.params.silent) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "Redo aborted");
                    }
                    return;
                }
                if (!this.params.silent && Config.askRedos && this.sender instanceof Player && !CommandsHandler.this.logblock.getQuestioner().ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Redo aborted");
                    return;
                }
                editor.start();
                this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "Redo finished successfully (" + editor.getElapsedTime() + " ms, " + editor.getSuccesses() + "/" + changes + " blocks" + (String)(editor.getErrors() > 0 ? ", " + org.bukkit.ChatColor.RED + editor.getErrors() + " errors" + org.bukkit.ChatColor.GREEN : "") + (String)(editor.getBlacklistCollisions() > 0 ? ", " + editor.getBlacklistCollisions() + " blacklist collisions" : "") + ")");
            }
            catch (Exception ex) {
                if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[Redo] " + this.params.getQuery() + ": ", ex);
                }
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandLookup
    extends AbstractCommand {
        public CommandLookup(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                try {
                    if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                        this.params.needDate = true;
                        this.params.needPlayer = true;
                        this.params.needMessage = true;
                    } else if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
                        this.params.needDate = true;
                        this.params.needPlayer = true;
                        this.params.needKiller = true;
                        this.params.needVictim = true;
                        this.params.needWeapon = true;
                    } else {
                        this.params.needDate = true;
                        this.params.needType = true;
                        this.params.needData = true;
                        this.params.needPlayer = true;
                        if (this.params.bct == QueryParams.BlockChangeType.CHESTACCESS || this.params.bct == QueryParams.BlockChangeType.ALL) {
                            this.params.needChestAccess = true;
                        }
                    }
                    this.conn = CommandsHandler.this.logblock.getConnection();
                    if (this.conn == null) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                        return;
                    }
                    this.state = this.conn.createStatement();
                    this.rs = CommandsHandler.this.executeQuery(this.state, this.params.getQuery());
                    this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + this.params.getTitle() + ":");
                    ArrayList<LookupCacheElement> blockchanges = new ArrayList<LookupCacheElement>();
                    LookupCacheElementFactory factory = new LookupCacheElementFactory(this.params, this.sender instanceof Player ? 0.6666667f : 1.0f);
                    while (this.rs.next()) {
                        blockchanges.add(factory.getLookupCacheElement(this.rs));
                    }
                    if (!blockchanges.isEmpty()) {
                        LookupCacheElement[] blockChangeArray = blockchanges.toArray(new LookupCacheElement[blockchanges.size()]);
                        if (!this.params.noCache) {
                            Session.getSession((CommandSender)this.sender).lookupCache = blockChangeArray;
                        }
                        if (this.params.sum == QueryParams.SummarizationMode.NONE) {
                            if (blockchanges.size() > Config.linesPerPage) {
                                this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA.toString() + blockchanges.size() + " changes found." + (blockchanges.size() == Config.linesLimit ? " Use 'limit -1' to see all changes." : ""));
                            }
                        } else {
                            int totalChanges = 0;
                            for (LookupCacheElement element : blockchanges) {
                                totalChanges += element.getNumChanges();
                            }
                            this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA.toString() + totalChanges + " changes found.");
                            if (this.params.bct == QueryParams.BlockChangeType.KILLS && this.params.sum == QueryParams.SummarizationMode.PLAYERS) {
                                this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA.toString() + blockchanges.size() + " distinct players found.");
                                this.sender.sendMessage(org.bukkit.ChatColor.GOLD + "Kills - Killed - Player");
                            } else {
                                this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA.toString() + blockchanges.size() + " distinct " + (this.params.sum == QueryParams.SummarizationMode.TYPES ? (this.params.bct == QueryParams.BlockChangeType.ENTITIES ? "entities" : "blocks") : "players") + " found.");
                                this.sender.sendMessage(org.bukkit.ChatColor.GOLD + "Created - Destroyed - " + (this.params.sum == QueryParams.SummarizationMode.TYPES ? (this.params.bct == QueryParams.BlockChangeType.ENTITIES ? "Entity" : "Block") : "Player"));
                            }
                        }
                        if (!this.params.noCache) {
                            CommandsHandler.showPage(this.sender, 1);
                        } else {
                            CommandsHandler.showPage(this.sender, 1, blockChangeArray, false);
                        }
                        break block25;
                    }
                    this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "No results found.");
                    if (!this.params.noCache) {
                        Session.getSession((CommandSender)this.sender).lookupCache = null;
                    }
                }
                catch (Exception ex) {
                    if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                        CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[Lookup] " + this.params.getQuery() + ": ", ex);
                    }
                }
                finally {
                    this.close();
                }
            }
        }
    }

    public class CommandWriteLogFile
    extends AbstractCommand {
        public CommandWriteLogFile(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = null;
            try {
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.params.needDate = true;
                    this.params.needPlayer = true;
                    this.params.needMessage = true;
                } else {
                    this.params.needDate = true;
                    this.params.needType = true;
                    this.params.needData = true;
                    this.params.needPlayer = true;
                    if (this.params.bct == QueryParams.BlockChangeType.CHESTACCESS || this.params.bct == QueryParams.BlockChangeType.ALL) {
                        this.params.needChestAccess = true;
                    }
                }
                this.conn = CommandsHandler.this.logblock.getConnection();
                if (this.conn == null) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                    return;
                }
                this.state = this.conn.createStatement();
                File dumpFolder = new File(CommandsHandler.this.logblock.getDataFolder(), "log");
                if (!dumpFolder.exists()) {
                    dumpFolder.mkdirs();
                }
                file = new File(dumpFolder, this.params.getTitle().replace(":", ".").replace("/", "_").replace("\\", "_") + ".log");
                this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "Creating " + file.getName());
                this.rs = CommandsHandler.this.executeQuery(this.state, this.params.getQuery());
                file.getParentFile().mkdirs();
                file.createNewFile();
                FileWriter writer = new FileWriter(file);
                String newline = System.getProperty("line.separator");
                file.getParentFile().mkdirs();
                int counter = 0;
                if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                    writer.write("Created - Destroyed - " + (this.params.sum == QueryParams.SummarizationMode.TYPES ? (this.params.bct == QueryParams.BlockChangeType.ENTITIES ? "Entity" : "Block") : "Player") + newline);
                }
                LookupCacheElementFactory factory = new LookupCacheElementFactory(this.params, this.sender instanceof Player ? 0.6666667f : 1.0f);
                while (this.rs.next()) {
                    writer.write(BaseComponent.toPlainText((BaseComponent[])factory.getLookupCacheElement(this.rs).getLogMessage()) + newline);
                    ++counter;
                }
                writer.close();
                this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "Wrote " + counter + " lines.");
            }
            catch (Exception ex) {
                if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[WriteLogFile] " + this.params.getQuery() + " (file was " + file.getAbsolutePath() + "): ", ex);
                }
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandClearLog
    extends AbstractCommand {
        public CommandClearLog(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object tableName;
                Object deleteFromTables;
                String tableBase;
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.conn.setAutoCommit(true);
                this.state = this.conn.createStatement();
                if (this.conn == null) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                    return;
                }
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Cannot summarize on ClearLog");
                    return;
                }
                this.params.needId = true;
                this.params.needDate = true;
                this.params.needPlayerId = true;
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.params.needMessage = true;
                    tableBase = "lb-chat";
                    deleteFromTables = "`lb-chat` ";
                    tableName = "lb-chat";
                } else if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
                    this.params.needWeapon = true;
                    this.params.needCoords = true;
                    tableBase = this.params.getTable();
                    deleteFromTables = "`" + tableBase + "-kills` ";
                    tableName = tableBase + "-kills";
                } else if (this.params.bct == QueryParams.BlockChangeType.ENTITIES || this.params.bct == QueryParams.BlockChangeType.ENTITIES_CREATED || this.params.bct == QueryParams.BlockChangeType.ENTITIES_KILLED) {
                    this.params.needType = true;
                    this.params.needCoords = true;
                    this.params.needData = true;
                    tableBase = this.params.getTable();
                    deleteFromTables = "`" + tableBase + "-entities` ";
                    tableName = tableBase + "-entities";
                } else {
                    this.params.needType = true;
                    this.params.needCoords = true;
                    this.params.needData = true;
                    this.params.needChestAccess = true;
                    tableBase = this.params.getTable();
                    deleteFromTables = "`" + tableBase + "-blocks`, `" + tableBase + "-state`, `" + tableBase + "-chestdata` ";
                    tableName = tableBase + "-blocks";
                }
                File dumpFolder = new File(CommandsHandler.this.logblock.getDataFolder(), "dump");
                if (!dumpFolder.exists()) {
                    dumpFolder.mkdirs();
                }
                this.rs = this.state.executeQuery("SELECT count(*) " + this.params.getFrom() + this.params.getWhere());
                int deleted = this.rs.next() ? this.rs.getInt(1) : 0;
                this.rs.close();
                if (!this.params.silent && Config.askClearLogs && this.sender instanceof Player) {
                    this.sender.sendMessage(org.bukkit.ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                    this.sender.sendMessage(org.bukkit.ChatColor.GREEN.toString() + deleted + " entries found.");
                    if (deleted == 0 || !CommandsHandler.this.logblock.getQuestioner().ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "ClearLog aborted");
                        return;
                    }
                }
                if (deleted > 0 && Config.dumpDeletedLog) {
                    String time = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(System.currentTimeMillis());
                    try {
                        File outFile = new File(dumpFolder, (time + " " + (String)tableName + " " + this.params.getTitle() + ".sql").replace(':', '.').replace('/', '_').replace('\\', '_'));
                        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), "UTF-8"));){
                            this.rs = this.state.executeQuery("SELECT " + this.params.getFields() + this.params.getFrom() + this.params.getWhere());
                            while (this.rs.next()) {
                                StringBuilder sb = new StringBuilder();
                                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                                    sb.append("INSERT INTO `lb-chat` (`id`, `date`, `playerid`, `message`) VALUES (");
                                    sb.append(this.rs.getInt("id")).append(", FROM_UNIXTIME(");
                                    sb.append(this.rs.getTimestamp("date").getTime() / 1000L).append("), ");
                                    sb.append(this.rs.getInt("playerid")).append(", '");
                                    sb.append(Utils.mysqlTextEscape(this.rs.getString("message")));
                                    sb.append("');\n");
                                } else if (this.params.bct == QueryParams.BlockChangeType.KILLS) {
                                    sb.append("INSERT INTO `").append(tableBase).append("-kills` (`id`, `date`, `killer`, `victim`, `weapon`, `x`, `y`, `z`) VALUES (");
                                    sb.append(this.rs.getInt("id")).append(", FROM_UNIXTIME(");
                                    sb.append(this.rs.getTimestamp("date").getTime() / 1000L).append("), ");
                                    sb.append(this.rs.getInt("killerid")).append(", ");
                                    sb.append(this.rs.getInt("victimid")).append(", ");
                                    sb.append(this.rs.getInt("weapon")).append(", ");
                                    sb.append(this.rs.getInt("x")).append(", ");
                                    sb.append(this.rs.getInt("y")).append(", ");
                                    sb.append(this.rs.getInt("z"));
                                    sb.append(");\n");
                                } else if (this.params.bct != QueryParams.BlockChangeType.ENTITIES && this.params.bct != QueryParams.BlockChangeType.ENTITIES_CREATED && this.params.bct != QueryParams.BlockChangeType.ENTITIES_KILLED) {
                                    byte[] item;
                                    sb.append("INSERT INTO `").append(tableBase).append("-blocks` (`id`, `date`, `playerid`, `replaced`, `replacedData`, `type`, `typeData`, `x`, `y`, `z`) VALUES (");
                                    sb.append(this.rs.getInt("id")).append(", FROM_UNIXTIME(");
                                    sb.append(this.rs.getTimestamp("date").getTime() / 1000L).append("), ");
                                    sb.append(this.rs.getInt("playerid")).append(", ");
                                    sb.append(this.rs.getInt("replaced")).append(", ");
                                    sb.append(this.rs.getInt("replacedData")).append(", ");
                                    sb.append(this.rs.getInt("type")).append(", ");
                                    sb.append(this.rs.getInt("typeData")).append(", ");
                                    sb.append(this.rs.getInt("x")).append(", ");
                                    sb.append(this.rs.getInt("y")).append(", ");
                                    sb.append(this.rs.getInt("z"));
                                    sb.append(");\n");
                                    byte[] replacedState = this.rs.getBytes("replacedState");
                                    byte[] typeState = this.rs.getBytes("typeState");
                                    if (replacedState != null || typeState != null) {
                                        sb.append("INSERT INTO `").append(tableBase).append("-state` (`id`, `replacedState`, `typeState`) VALUES (");
                                        sb.append(this.rs.getInt("id")).append(", ");
                                        sb.append(Utils.mysqlPrepareBytesForInsertAllowNull(replacedState)).append(", ");
                                        sb.append(Utils.mysqlPrepareBytesForInsertAllowNull(typeState));
                                        sb.append(");\n");
                                    }
                                    if ((item = this.rs.getBytes("item")) != null) {
                                        sb.append("INSERT INTO `").append(tableBase).append("-chestdata` (`id`, `item`, `itemremove`, `itemtype`) VALUES (");
                                        sb.append(this.rs.getInt("id")).append(", ");
                                        sb.append(Utils.mysqlPrepareBytesForInsertAllowNull(item)).append(", ");
                                        sb.append(this.rs.getInt("itemremove")).append(", ");
                                        sb.append(this.rs.getInt("itemtype"));
                                        sb.append(");\n");
                                    }
                                }
                                writer.write(sb.toString());
                            }
                            this.rs.close();
                        }
                    }
                    catch (SQLException ex) {
                        this.sender.sendMessage(org.bukkit.ChatColor.RED + "Error while dumping log.");
                        CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[ClearLog] Exception while dumping log: ", ex);
                        this.close();
                        return;
                    }
                }
                if (deleted > 0) {
                    this.state.executeUpdate("DELETE " + (String)deleteFromTables + this.params.getFrom() + this.params.getWhere());
                    if (this.params.bct == QueryParams.BlockChangeType.ENTITIES || this.params.bct == QueryParams.BlockChangeType.ENTITIES_CREATED || this.params.bct == QueryParams.BlockChangeType.ENTITIES_KILLED) {
                        this.state.executeUpdate("DELETE `" + tableBase + "-entityids` FROM `" + tableBase + "-entityids` LEFT JOIN `" + tableBase + "-entities` USING (entityid) WHERE `" + tableBase + "-entities`.entityid IS NULL");
                    }
                }
                this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "Cleared out table " + (String)tableName + ". Deleted " + deleted + " entries.");
            }
            catch (Exception ex) {
                if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[ClearLog] Exception: ", ex);
                }
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandTeleport
    extends AbstractCommand {
        public CommandTeleport(CommandSender sender, QueryParams params, boolean async) throws Exception {
            super(sender, params, async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.params.needCoords = true;
                if (this.params.bct == QueryParams.BlockChangeType.CHESTACCESS || this.params.bct == QueryParams.BlockChangeType.ALL) {
                    this.params.needChestAccess = true;
                }
                this.params.limit = 1;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                if (this.conn == null) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "MySQL connection lost");
                    return;
                }
                this.state = this.conn.createStatement();
                this.rs = CommandsHandler.this.executeQuery(this.state, this.params.getQuery());
                if (this.rs.next()) {
                    final Player player = (Player)this.sender;
                    final int y = this.rs.getInt("y");
                    final Location loc = new Location(this.params.world, (double)this.rs.getInt("x") + 0.5, (double)y, (double)this.rs.getInt("z") + 0.5, player.getLocation().getYaw(), 90.0f);
                    CommandsHandler.this.logblock.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CommandsHandler.this.logblock, new Runnable(){

                        @Override
                        public void run() {
                            int y2 = BukkitUtils.saveSpawnHeight(loc);
                            loc.setY((double)y2);
                            player.teleport(loc);
                            CommandTeleport.this.sender.sendMessage(org.bukkit.ChatColor.GREEN + "You were teleported " + Math.abs(y2 - y) + " blocks " + (y2 - y > 0 ? "above" : "below"));
                        }
                    });
                } else {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "No block change found to teleport to");
                }
            }
            catch (Exception ex) {
                if (CommandsHandler.this.logblock.isCompletelyEnabled() || !(ex instanceof SQLException)) {
                    this.sender.sendMessage(org.bukkit.ChatColor.RED + "Exception, check error log");
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[Teleport] " + this.params.getQuery() + ": ", ex);
                }
            }
            finally {
                this.close();
            }
        }
    }

    public abstract class AbstractCommand
    implements Runnable {
        protected CommandSender sender;
        protected QueryParams params;
        protected Connection conn = null;
        protected Statement state = null;
        protected ResultSet rs = null;

        protected AbstractCommand(CommandSender sender, QueryParams params, boolean async) throws Exception {
            this.sender = sender;
            QueryParams queryParams = this.params = params == null ? null : params.clone();
            if (async) {
                CommandsHandler.this.scheduler.runTaskAsynchronously((Plugin)CommandsHandler.this.logblock, (Runnable)this);
            } else {
                this.run();
            }
        }

        public final void close() {
            block5: {
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                    if (this.state != null) {
                        this.state.close();
                    }
                    if (this.rs != null) {
                        this.rs.close();
                    }
                }
                catch (SQLException ex) {
                    if (!CommandsHandler.this.logblock.isCompletelyEnabled()) break block5;
                    CommandsHandler.this.logblock.getLogger().log(Level.SEVERE, "[CommandsHandler] SQL exception on close", ex);
                }
            }
        }
    }
}

