/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BlockVector;

public class CuboidRegion
implements Cloneable {
    private World world;
    private BlockVector min = new BlockVector();
    private BlockVector max = new BlockVector();

    public CuboidRegion(World world, BlockVector first, BlockVector second) {
        this.world = world;
        this.min.setX(Math.min(first.getBlockX(), second.getBlockX()));
        this.min.setY(Math.min(first.getBlockY(), second.getBlockY()));
        this.min.setZ(Math.min(first.getBlockZ(), second.getBlockZ()));
        this.max.setX(Math.max(first.getBlockX(), second.getBlockX()));
        this.max.setY(Math.max(first.getBlockY(), second.getBlockY()));
        this.max.setZ(Math.max(first.getBlockZ(), second.getBlockZ()));
    }

    public static CuboidRegion fromCorners(World world, Location first, Location second) {
        return new CuboidRegion(world, new BlockVector(first.getBlockX(), first.getBlockY(), first.getBlockZ()), new BlockVector(second.getBlockX(), second.getBlockY(), second.getBlockZ()));
    }

    public World getWorld() {
        return this.world;
    }

    public BlockVector getMinimumPoint() {
        return this.min;
    }

    public BlockVector getMaximumPoint() {
        return this.max;
    }

    public int getSizeX() {
        return this.max.getBlockX() - this.min.getBlockX() + 1;
    }

    public int getSizeZ() {
        return this.max.getBlockZ() - this.min.getBlockZ() + 1;
    }

    public CuboidRegion clone() {
        try {
            CuboidRegion clone = (CuboidRegion)super.clone();
            clone.min = this.min.clone();
            clone.max = this.max.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("CuboidRegion should be cloneable", ex);
        }
    }
}

