/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class MaterialConverter {
    private static String[] idToMaterial = new String[10];
    private static HashMap<String, Integer> materialToID = new HashMap();
    private static int nextMaterialId;
    private static String[] idToBlockState;
    private static HashMap<String, Integer> blockStateToID;
    private static int nextBlockStateId;
    private static HashMap<String, Material> materialKeyToMaterial;

    public static synchronized Integer getExistingMaterialId(BlockData blockData) {
        return blockData == null ? null : MaterialConverter.getExistingMaterialId(blockData.getMaterial());
    }

    public static synchronized Integer getExistingMaterialId(Material material) {
        if (material == null) {
            return null;
        }
        String materialString = material.getKey().toString();
        return materialToID.get(materialString);
    }

    public static synchronized int getOrAddMaterialId(BlockData blockData) {
        return MaterialConverter.getOrAddMaterialId(blockData == null ? Material.AIR : blockData.getMaterial());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getOrAddMaterialId(Material material) {
        if (material == null) {
            material = Material.AIR;
        }
        String materialString = material.getKey().toString();
        Integer key = materialToID.get(materialString);
        int tries = 0;
        while (key == null && tries < 10) {
            ++tries;
            key = nextMaterialId;
            Connection conn = LogBlock.getInstance().getConnection();
            try {
                conn.setAutoCommit(false);
                PreparedStatement smt = conn.prepareStatement("INSERT IGNORE INTO `lb-materials` (id, name) VALUES (?, ?)");
                smt.setInt(1, key);
                smt.setString(2, materialString);
                boolean couldAdd = smt.executeUpdate() > 0;
                conn.commit();
                smt.close();
                if (couldAdd) {
                    MaterialConverter.internalAddMaterial(key, materialString);
                } else {
                    MaterialConverter.initializeMaterials(conn);
                }
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not update lb-materials", e);
                MaterialConverter.reinitializeMaterialsCatchException();
                if (tries == 10) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            key = materialToID.get(materialString);
        }
        return key;
    }

    public static synchronized Integer getExistingBlockStateId(BlockData blockData) {
        if (blockData == null) {
            return -1;
        }
        String blockDataString = blockData.getAsString();
        int dataPart = blockDataString.indexOf("[");
        if (dataPart < 0) {
            return -1;
        }
        String materialString = blockDataString.substring(dataPart);
        return blockStateToID.get(materialString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getOrAddBlockStateId(BlockData blockData) {
        if (blockData == null) {
            return -1;
        }
        String blockDataString = blockData.getAsString();
        int dataPart = blockDataString.indexOf("[");
        if (dataPart < 0) {
            return -1;
        }
        String materialString = blockDataString.substring(dataPart);
        Integer key = blockStateToID.get(materialString);
        int tries = 0;
        while (key == null && tries < 10) {
            ++tries;
            key = nextBlockStateId;
            Connection conn = LogBlock.getInstance().getConnection();
            try {
                conn.setAutoCommit(false);
                PreparedStatement smt = conn.prepareStatement("INSERT IGNORE INTO `lb-blockstates` (id, name) VALUES (?, ?)");
                smt.setInt(1, key);
                smt.setString(2, materialString);
                boolean couldAdd = smt.executeUpdate() > 0;
                conn.commit();
                smt.close();
                if (couldAdd) {
                    MaterialConverter.internalAddBlockState(key, materialString);
                } else {
                    MaterialConverter.initializeMaterials(conn);
                }
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not update lb-blockstates", e);
                MaterialConverter.reinitializeMaterialsCatchException();
                if (tries == 10) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            key = blockStateToID.get(materialString);
        }
        return key;
    }

    public static synchronized BlockData getBlockData(int materialId, int blockStateId) {
        String material;
        String string = material = materialId >= 0 && materialId < idToMaterial.length ? idToMaterial[materialId] : null;
        if (material == null) {
            return null;
        }
        if (blockStateId >= 0 && blockStateId < idToBlockState.length && idToBlockState[blockStateId] != null) {
            material = material + idToBlockState[blockStateId];
        }
        try {
            return Bukkit.createBlockData((String)material);
        }
        catch (IllegalArgumentException ignored) {
            try {
                return Bukkit.createBlockData((String)idToMaterial[materialId]);
            }
            catch (IllegalArgumentException ignored2) {
                return null;
            }
        }
    }

    public static synchronized Material getMaterial(int materialId) {
        return materialId >= 0 && materialId < idToMaterial.length ? materialKeyToMaterial.get(idToMaterial[materialId]) : null;
    }

    private static void reinitializeMaterialsCatchException() {
        Connection conn = LogBlock.getInstance().getConnection();
        try {
            MaterialConverter.initializeMaterials(conn);
        }
        catch (Exception e) {
            LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not reinitialize lb-materials", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static synchronized void initializeMaterials(Connection connection) throws SQLException {
        String materialString;
        int key;
        Statement smt = connection.createStatement();
        ResultSet rs = smt.executeQuery("SELECT id, name FROM `lb-materials`");
        while (rs.next()) {
            key = rs.getInt(1);
            materialString = rs.getString(2);
            MaterialConverter.internalAddMaterial(key, materialString);
        }
        rs.close();
        rs = smt.executeQuery("SELECT id, name FROM `lb-blockstates`");
        while (rs.next()) {
            key = rs.getInt(1);
            materialString = rs.getString(2);
            MaterialConverter.internalAddBlockState(key, materialString);
        }
        rs.close();
        smt.close();
        connection.close();
    }

    private static void internalAddMaterial(int key, String materialString) {
        materialToID.put(materialString, key);
        int length = idToMaterial.length;
        while (length <= key) {
            length = length * 3 / 2 + 5;
        }
        if (length > idToMaterial.length) {
            idToMaterial = Arrays.copyOf(idToMaterial, length);
        }
        MaterialConverter.idToMaterial[key] = materialString;
        if (nextMaterialId <= key) {
            nextMaterialId = key + 1;
        }
    }

    private static void internalAddBlockState(int key, String materialString) {
        blockStateToID.put(materialString, key);
        int length = idToBlockState.length;
        while (length <= key) {
            length = length * 3 / 2 + 5;
        }
        if (length > idToBlockState.length) {
            idToBlockState = Arrays.copyOf(idToBlockState, length);
        }
        MaterialConverter.idToBlockState[key] = materialString;
        if (nextBlockStateId <= key) {
            nextBlockStateId = key + 1;
        }
    }

    static {
        idToBlockState = new String[10];
        blockStateToID = new HashMap();
        materialKeyToMaterial = new HashMap();
        for (Material m : Material.values()) {
            materialKeyToMaterial.put(m.getKey().toString(), m);
        }
    }
}

