/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Object> {
    public static final String[] releaseLevels = new String[]{"release", "alpha", "beta", "rc"};
    private static final Pattern REGEX_BUILD_NUMBER = Pattern.compile(".*b(\\d+).*");
    private final String rawVersion;
    private int major;
    private int minor;
    private int patch;
    private int releaseLevelWeight;
    private int releaseLevel;
    private int buildNumber;

    public Version(String version) {
        this.rawVersion = version.contains("-git-") ? version.substring(0, version.indexOf("-git-")) : version;
        this.calculateWeights();
    }

    public boolean newerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean olderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.major > 0) {
            builder.append(this.major);
            builder.append(".");
            builder.append(this.minor);
            builder.append(".");
            builder.append(this.patch);
        }
        if (this.releaseLevel > 0) {
            String level = releaseLevels[this.releaseLevel];
            builder.append("-");
            builder.append(level);
            builder.append(this.releaseLevelWeight);
        }
        if (this.buildNumber > 0) {
            if (this.major > 0) {
                builder.append(" ");
                builder.append("(b");
                builder.append(this.buildNumber);
                builder.append(")");
            } else {
                builder.append("b");
                builder.append(this.buildNumber);
            }
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return version.compareTo(this) == 0;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof Version)) {
            return 0;
        }
        Version version = (Version)o;
        return this.compareTo(version);
    }

    @Override
    public int compareTo(Version o) {
        if (this.buildNumber > 0 && o.getBuildNumber() > 0) {
            if (this.buildNumber > o.getBuildNumber()) {
                return 1;
            }
            if (this.buildNumber < o.getBuildNumber()) {
                return -1;
            }
        }
        if (this.major > o.getMajor()) {
            return 1;
        }
        if (this.major < o.getMajor()) {
            return -1;
        }
        if (this.minor > o.getMinor()) {
            return 1;
        }
        if (this.minor < o.getMinor()) {
            return -1;
        }
        if (this.patch > o.getPatch()) {
            return 1;
        }
        if (this.patch < o.getPatch()) {
            return -1;
        }
        if (this.releaseLevel != 0 || o.getReleaseLevel() != 0) {
            if (this.releaseLevel == 0 || o.getReleaseLevel() == 0) {
                return this.releaseLevel == 0 ? 1 : -1;
            }
            if (this.releaseLevel > o.getReleaseLevel()) {
                return 1;
            }
            if (this.releaseLevel < o.getReleaseLevel()) {
                return -1;
            }
            if (this.releaseLevelWeight > o.getReleaseLevelWeight()) {
                return 1;
            }
            if (this.releaseLevelWeight < o.getReleaseLevelWeight()) {
                return -1;
            }
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getReleaseLevelWeight() {
        return this.releaseLevelWeight;
    }

    public int getReleaseLevel() {
        return this.releaseLevel;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getRawVersion() {
        return this.rawVersion;
    }

    private void calculateWeights() {
        Matcher matcher;
        if (this.rawVersion.isEmpty()) {
            return;
        }
        this.major = this.parseNumber(this.rawVersion);
        int minorIndex = this.rawVersion.indexOf(".") + 1;
        this.minor = this.parseNumber(this.rawVersion.substring(minorIndex));
        int patchIndex = minorIndex + Integer.toString(this.minor).length() + 1;
        this.patch = patchIndex < this.rawVersion.length() ? this.parseNumber(this.rawVersion.substring(patchIndex)) : 0;
        for (int index = 0; index < releaseLevels.length; ++index) {
            String level = releaseLevels[index];
            if (!this.rawVersion.contains(level)) continue;
            this.releaseLevel = index;
            int levelIndex = this.rawVersion.indexOf(level) + level.length();
            if (levelIndex < this.rawVersion.length()) {
                this.releaseLevelWeight = this.parseNumber(this.rawVersion.substring(levelIndex));
                break;
            }
            this.releaseLevelWeight = 1;
            break;
        }
        if ((matcher = REGEX_BUILD_NUMBER.matcher(this.rawVersion)).matches()) {
            this.buildNumber = Integer.parseInt(matcher.group(1));
        }
    }

    private int parseNumber(String str) {
        if (str.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            int found = 0;
            for (int index = 1; index < str.length(); ++index) {
                String peek = str.substring(0, index);
                try {
                    found = Integer.parseInt(peek);
                    continue;
                }
                catch (NumberFormatException e) {
                    return found;
                }
            }
            return found;
        }
    }
}

