/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;

public class AdminTags
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("tags")) {
            return;
        }
        event.setCancelled(true);
        if (args.length < 2) {
            LWC.getInstance().sendSimpleUsage(sender, "/lwc admin tags <block>");
            return;
        }
        String block = args[1];
        if (block.startsWith("#")) {
            NamespacedKey blockKey = NamespacedKey.fromString((String)(block = block.substring(1)));
            if (blockKey == null) {
                sender.sendMessage("\u00a74Invalid Tag");
                return;
            }
            Tag blockTag = Bukkit.getServer().getTag("blocks", blockKey, Material.class);
            if (blockTag == null) {
                sender.sendMessage("\u00a74Invalid Tag");
                return;
            }
            sender.sendMessage(" ");
            sender.sendMessage("\u00a74 ==== Blocks for #" + blockTag.getKey().asMinimalString() + " ==== ");
            for (Material mat : blockTag.getValues()) {
                sender.sendMessage("\u00a72" + mat.getKey().asMinimalString());
            }
            return;
        }
        NamespacedKey blockKey = NamespacedKey.fromString((String)block);
        if (blockKey == null) {
            sender.sendMessage("\u00a74Invalid Block");
            return;
        }
        Material material = (Material)Registry.MATERIAL.get(blockKey);
        if (material == null || !material.isBlock()) {
            sender.sendMessage("\u00a74Invalid Block");
            return;
        }
        sender.sendMessage(" ");
        sender.sendMessage("\u00a74 ==== Tags for " + blockKey.asMinimalString() + " ==== ");
        for (Tag tag : Bukkit.getServer().getTags("blocks", Material.class)) {
            if (!tag.isTagged((Keyed)material)) continue;
            sender.sendMessage("\u00a72#" + tag.getKey().asMinimalString());
        }
    }
}

