/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.migration;

import com.griefcraft.lwc.LWC;
import com.griefcraft.migration.DatabaseMigrator;
import com.griefcraft.migration.MigrationUtility;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import java.io.File;
import java.util.logging.Logger;

public class MySQLPost200
implements MigrationUtility {
    private static Logger logger = Logger.getLogger("Patcher");

    @Override
    public void run() {
        File file;
        LWC lwc = LWC.getInstance();
        PhysDB physicalDatabase = lwc.getPhysicalDatabase();
        if (physicalDatabase.getType() != Database.Type.MySQL) {
            return;
        }
        String database = lwc.getConfiguration().getString("database.path");
        if (database == null || database.trim().equals("")) {
            database = "plugins/LWC/lwc.db";
        }
        if (!(file = new File(database)).exists()) {
            return;
        }
        logger.info("######################################################");
        logger.info("######################################################");
        logger.info("SQLite to MySQL conversion required");
        DatabaseMigrator migrator = new DatabaseMigrator();
        lwc.reloadDatabase();
        PhysDB sqlite = new PhysDB(Database.Type.SQLite);
        try {
            sqlite.connect();
            sqlite.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (migrator.migrate(sqlite, lwc.getPhysicalDatabase())) {
            logger.info("Successfully converted.");
            logger.info("Renaming \"" + database + "\" to \"" + database + ".old\"");
            if (!file.renameTo(new File(database + ".old"))) {
                logger.info("NOTICE: FAILED TO RENAME lwc.db!! Please rename this manually!");
            }
            logger.info("SQLite to MySQL conversion is now complete!\n");
            logger.info("Thank you!");
        } else {
            logger.info("#### SEVERE ERROR: Something bad happened when converting the database (Oops!)");
        }
        logger.info("######################################################");
        logger.info("######################################################");
    }
}

