/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class WeakLRUCache<K, V>
implements Map<K, V> {
    private final LinkedHashMap<K, WeakValue<V, K>> weakCache;
    private final ReferenceQueue<? super V> queue = new ReferenceQueue();
    protected int maxCapacity;
    private long reads = 0L;
    private long writes = 0L;

    public WeakLRUCache(int capacity) {
        this.maxCapacity = capacity;
        this.weakCache = new LinkedHashMap<K, WeakValue<V, K>>(this.maxCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, WeakValue<V, K>> eldest) {
                return this.size() > WeakLRUCache.this.maxCapacity;
            }
        };
    }

    public long getReads() {
        return this.reads;
    }

    public long getWrites() {
        return this.writes;
    }

    private void processQueue() {
        WeakValue weakValue;
        while ((weakValue = (WeakValue)this.queue.poll()) != null) {
            this.weakCache.remove(weakValue.key);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.weakCache.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.weakCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.weakCache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        return this.weakCache.containsValue(value);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.weakCache.clear();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.weakCache.keySet();
    }

    @Override
    public V get(Object key) {
        ++this.reads;
        this.processQueue();
        WeakValue<V, K> weakRef = this.weakCache.get(key);
        V result = null;
        if (weakRef != null && (result = (V)weakRef.get()) == null) {
            this.weakCache.remove(key);
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        ++this.writes;
        this.processQueue();
        WeakValue<? super V, K> oldRef = this.weakCache.put(key, new WeakValue<V, K>(value, key, this.queue));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        WeakValue old = (WeakValue)this.weakCache.remove(key);
        return old != null ? (V)old.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("putAll() is not supported by WeakLRUCache");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("values() is not supported by WeakLRUCache");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet() is not supported by WeakLRUCache");
    }

    private final class WeakValue<V, K>
    extends WeakReference<V> {
        private final K key;

        private WeakValue(V value, K key, ReferenceQueue<? super V> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

