/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.google.common.base.Preconditions;
import com.griefcraft.lwc.LWC;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class BlockMap {
    private static BlockMap instance = new BlockMap();
    private EnumMap<Material, Integer> blockToIdMap = new EnumMap(Material.class);
    private Material[] idToBlockMap = new Material[64];

    public static BlockMap instance() {
        return instance;
    }

    private BlockMap() {
    }

    public void init() {
        this.blockToIdMap.clear();
        this.idToBlockMap = new Material[64];
        HashMap<Integer, String> existingMappings = LWC.getInstance().getPhysicalDatabase().loadBlockMappings();
        HashMap<String, Integer> inverseMappings = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> e : existingMappings.entrySet()) {
            inverseMappings.put(e.getValue(), e.getKey());
        }
        for (Map.Entry<Integer, String> e : existingMappings.entrySet()) {
            int id = e.getKey();
            String name = e.getValue();
            Material mat = Material.getMaterial((String)name);
            if (mat == null) {
                mat = Material.getMaterial((String)name, (boolean)true);
                if (name.equals("BURNING_FURNACE")) {
                    mat = Material.FURNACE;
                } else if (name.equals("STANDING_BANNER")) {
                    mat = Material.AIR;
                }
                if (mat == null || mat == Material.AIR) {
                    if (mat == null) {
                        LWC.getInstance().getPlugin().getLogger().severe("Invalid block mapping: " + name);
                    } else {
                        LWC.getInstance().getPlugin().getLogger().info("Updating block mapping from " + name + " to UNKNOWN");
                    }
                    LWC.getInstance().getPhysicalDatabase().mergeBlockMapping(id, -1);
                    inverseMappings.remove(name);
                    continue;
                }
                LWC.getInstance().getPlugin().getLogger().info("Updating block mapping from " + name + " to " + mat.name());
                Integer mergeId = (Integer)inverseMappings.get(mat.name());
                if (mergeId != null) {
                    LWC.getInstance().getPlugin().getLogger().info("Merging block mapping with " + mergeId);
                    LWC.getInstance().getPhysicalDatabase().mergeBlockMapping(id, mergeId);
                    inverseMappings.remove(name);
                    continue;
                }
                LWC.getInstance().getPhysicalDatabase().updateBlockMappingName(id, mat.name());
                inverseMappings.remove(name);
                inverseMappings.put(mat.name(), id);
            }
            this.internalAddMapping(id, mat);
        }
    }

    private void internalAddMapping(int id, Material mat) {
        this.blockToIdMap.put(mat, id);
        if (this.idToBlockMap.length <= id) {
            this.idToBlockMap = Arrays.copyOf(this.idToBlockMap, Math.max(this.idToBlockMap.length * 2, id + 1));
        }
        this.idToBlockMap[id] = mat;
    }

    public int getId(Material mat) {
        Integer val = this.blockToIdMap.get(mat);
        return val == null ? -1 : val;
    }

    public Material getMaterial(int id) {
        return id >= 0 && id < this.idToBlockMap.length ? this.idToBlockMap[id] : null;
    }

    public int registerOrGetId(Material mat) {
        int id;
        Preconditions.checkNotNull((Object)mat, (Object)"mat may not be null");
        Integer val = this.blockToIdMap.get(mat);
        if (val != null) {
            return val;
        }
        for (id = 1; this.getMaterial(id) != null || id == 5000; ++id) {
        }
        this.internalAddMapping(id, mat);
        LWC.getInstance().getPhysicalDatabase().addBlockMapping(id, mat.name());
        return id;
    }
}

