/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.lwc.LWC;
import com.griefcraft.sql.Column;
import com.griefcraft.sql.Database;
import com.griefcraft.util.Statistics;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class Table {
    private List<Column> columns;
    private Database database;
    private boolean memory;
    private String name;

    public Table(Database database, String name) {
        this.database = database;
        this.name = name;
        this.columns = new ArrayList<Column>();
    }

    public void add(Column column) {
        column.setTable(this);
        this.columns.add(column);
    }

    public void execute() throws SQLException {
        StringBuilder buffer = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        String prefix = LWC.getInstance().getConfiguration().getString("database.prefix", "");
        if (prefix == null) {
            prefix = "";
        }
        buffer.append(prefix).append(this.name);
        buffer.append(" ( ");
        for (int index = 0; index < this.columns.size(); ++index) {
            Column column = this.columns.get(index);
            buffer.append(column.getName());
            buffer.append(" ");
            buffer.append(column.getType());
            buffer.append(" ");
            if (column.isPrimary()) {
                buffer.append("PRIMARY KEY ");
            }
            if (column.shouldAutoIncrement() && this.database.getType() == Database.Type.MySQL) {
                buffer.append("AUTO_INCREMENT ");
            }
            if (!column.getDefaultValue().isEmpty()) {
                buffer.append("DEFAULT ");
                buffer.append(column.getDefaultValue());
                buffer.append(" ");
            }
            if (index == this.columns.size() - 1) continue;
            buffer.append(",");
            buffer.append(" ");
        }
        buffer.append(" ) ");
        if (this.memory && this.database.getType() == Database.Type.MySQL) {
            buffer.append("ENGINE = MEMORY");
        }
        buffer.append(";");
        Statement statement = this.database.getConnection().createStatement();
        statement.executeUpdate(buffer.toString());
        statement.close();
        Statistics.addQuery();
    }

    public boolean isInMemory() {
        return this.memory;
    }

    public void setMemory(boolean memory) {
        this.memory = memory;
    }
}

