/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.griefcraft.lwc.MessageParser;
import com.griefcraft.util.Colors;
import com.griefcraft.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class SimpleMessageParser
implements MessageParser {
    private final ResourceBundle locale;
    private final Map<String, String> basicMessageCache = new HashMap<String, String>();
    private final Map<String, String> bindMessageCache = new HashMap<String, String>();

    public SimpleMessageParser(ResourceBundle locale) {
        this.locale = locale;
    }

    @Override
    public String parseMessage(String key, Object ... args) {
        key = StringUtil.fastReplace(key, ' ', '_');
        Object cacheKey = key;
        if (args != null && args.length > 0) {
            for (Object object : args) {
                cacheKey = (String)cacheKey + object.toString();
            }
        }
        if (this.bindMessageCache.containsKey(cacheKey)) {
            return this.bindMessageCache.get(cacheKey);
        }
        if (!this.locale.containsKey(key)) {
            return null;
        }
        Map<String, Object> bind = this.parseBinds(args);
        String value = this.basicMessageCache.get(key);
        if (value == null) {
            String[] aliasvars;
            value = this.locale.getString(key);
            for (String string : Colors.localeColors.keySet()) {
                String color = Colors.localeColors.get(string);
                if (!value.contains(string)) continue;
                value = StringUtil.fastReplace(value, string, color);
            }
            for (String alias : aliasvars = new String[]{"cprivate", "cpublic", "cpassword", "cmodify", "cunlock", "cinfo", "cremove"}) {
                String replace = "%" + alias + "%";
                if (!value.contains(replace)) continue;
                String localeName = alias + ".basic";
                value = value.replace(replace, this.parseMessage(localeName, new Object[0]));
            }
            this.basicMessageCache.put(key, value);
        }
        for (String string : bind.keySet()) {
            Object object = bind.get(string);
            value = StringUtil.fastReplace(value, "%" + string + "%", object.toString());
        }
        this.bindMessageCache.put((String)cacheKey, value);
        return value;
    }

    private Map<String, Object> parseBinds(Object ... args) {
        HashMap<String, Object> bind = new HashMap<String, Object>();
        if (args == null || args.length < 2) {
            return bind;
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The given arguments length must be equal");
        }
        int size = args.length;
        for (int index = 0; index < args.length && index + 2 <= size; index += 2) {
            String key = args[index].toString();
            Object object = args[index + 1];
            bind.put(key, object);
        }
        return bind;
    }
}

