/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.History;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

public class AdminRebuild
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("rebuild")) {
            return;
        }
        event.setCancelled(true);
        if (args.length == 1 || !args[1].equalsIgnoreCase("confirm")) {
            sender.sendMessage("This will attempt to rebuild the entire LWC database from scratch.");
            sender.sendMessage("This WILL repair most of the database, regarding the incident on February 15, 2012. However, please note that old protections may be restored.");
            sender.sendMessage("This may take some time so it is recommended it is ran inside the console.");
            sender.sendMessage("\u00a74Are you sure you would like to go ahead? Use /lwc admin rebuild confirm to confirm.");
        } else if (args[1].equalsIgnoreCase("confirm")) {
            this.rebuildDatabase(sender);
        }
    }

    private void rebuildDatabase(CommandSender sender) {
        LWC lwc = LWC.getInstance();
        sender.sendMessage("Now rebuilding the LWC database.");
        lwc.getProtectionCache().clear();
        List<History> fullHistory = lwc.getPhysicalDatabase().loadHistory(History.Status.ACTIVE);
        sender.sendMessage("Loaded " + fullHistory.size() + " history objects");
        long start = System.currentTimeMillis();
        int created = 0;
        int failed = 0;
        Iterator<History> iter = fullHistory.iterator();
        while (iter.hasNext()) {
            History history = iter.next();
            if (history.getProtection() != null) {
                iter.remove();
                continue;
            }
            int x = history.getX();
            int y = history.getY();
            int z = history.getZ();
            if (x == 0 && y == 0 && z == 0) {
                iter.remove();
                continue;
            }
            String creator = history.getString("creator");
            if (creator == null) {
                sender.sendMessage(String.format("Unable to match owner at Id:%d", history.getId()));
                ++failed;
                iter.remove();
                continue;
            }
            Block block = this.findProtectableBlock(x, y, z);
            if (block == null) {
                sender.sendMessage(String.format("Unable to match block at Id:%d [%d, %d, %d] (this is probably OK)", history.getId(), x, y, z));
                ++failed;
                iter.remove();
                continue;
            }
            Protection protection = lwc.getPhysicalDatabase().registerProtection(block.getType(), Protection.Type.PRIVATE, block.getWorld().getName(), creator, "", x, y, z);
            if (protection == null) {
                sender.sendMessage(String.format("Failed to create protection at Id:%d", history.getId()));
                ++failed;
                iter.remove();
                continue;
            }
            ++created;
            history.remove();
            protection.saveNow();
            iter.remove();
            lwc.getProtectionCache().clear();
        }
        int total = created + failed;
        long runningTime = System.currentTimeMillis() - start;
        int runningTimeSeconds = (int)runningTime / 1000;
        float ratio = (float)created / (float)total * 100.0f;
        sender.sendMessage(String.format("LWC rebuild complete (%ds). %.2f%% conversion ratio; %d success and %d failures", runningTimeSeconds, Float.valueOf(ratio), created, failed));
    }

    private Block findProtectableBlock(int x, int y, int z) {
        LWC lwc = LWC.getInstance();
        Server server = Bukkit.getServer();
        for (World world : server.getWorlds()) {
            Block block = world.getBlockAt(x, y, z);
            if (!lwc.isProtectable(block)) continue;
            return block;
        }
        return null;
    }
}

